/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSDestructuringPropertyBase;
import com.intellij.lang.javascript.psi.stubs.impl.JSDestructuringPropertyStubImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDestructuringPropertyImpl
extends JSDestructuringPropertyBase<JSDestructuringProperty, JSDestructuringPropertyStubImpl>
implements JSNamedElement {
    public JSDestructuringPropertyImpl(ASTNode node) {
        super(node);
    }

    public JSDestructuringPropertyImpl(JSDestructuringPropertyStubImpl stub) {
        super(stub, (IStubElementType)JSStubElementTypes.DESTRUCTURING_PROPERTY);
    }

    @Override
    @Nullable
    protected String getNameTextImpl() {
        PsiElement identifier = this.getNameIdentifier();
        return identifier != null ? identifier.getText() : null;
    }

    @Nullable
    public ASTNode findNameIdentifier() {
        PsiElement identifier = this.getNameIdentifier();
        return identifier != null ? identifier.getNode() : null;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/impl/JSDestructuringPropertyImpl", "setName"));
        }
        ASTNode nameNode = this.findNameIdentifier();
        if (nameNode == null) {
            return this;
        }
        ASTNode parentForReplace = nameNode.getTreeParent();
        ASTNode nameElement = JSChangeUtil.createNameIdentifier(this.getProject(), name, nameNode.getElementType());
        parentForReplace.replaceChild(nameNode, nameElement);
        return this;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.getNameIdentifierForPropertyOrNestedElement();
    }
}

