/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecmal4.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSSuppressionHolder;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.impl.ActionScriptClassBase;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSClassStub;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.IncorrectOperationException;
import icons.JavaScriptPsiIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ActionScriptClassImpl
extends ActionScriptClassBase<JSClassStub<JSClass>>
implements JSSuppressionHolder {
    public static final Icon CLASS_ICON = JavaScriptPsiIcons.Classes.ActionScriptClass;
    public static final Icon INTERFACE_ICON = JavaScriptPsiIcons.Classes.ActionScriptInterface;

    public ActionScriptClassImpl(ASTNode node) {
        super(node);
    }

    public ActionScriptClassImpl(JSClassStub<JSClass> stub) {
        super(stub, JSStubElementTypes.CLASS);
    }

    public boolean isInterface() {
        JSClassStub classStub = (JSClassStub)this.getStub();
        if (classStub != null) {
            return classStub.isInterface();
        }
        return this.getNode().findChildByType(JSTokenTypes.INTERFACE_KEYWORD) != null;
    }

    @Override
    public boolean isDeprecated() {
        if (JSPsiImplUtils.isDeprecatedFromAttribute((JSAttributeListOwner)this)) {
            return true;
        }
        JSClassStub stub = (JSClassStub)this.getStub();
        if (stub != null) {
            return stub.isDeprecated();
        }
        return JSDocumentationUtils.calculateDeprecated((PsiElement)this);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState substitutor, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/ecmal4/impl/ActionScriptClassImpl", "processDeclarations"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/lang/javascript/psi/ecmal4/impl/ActionScriptClassImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/ecmal4/impl/ActionScriptClassImpl", "processDeclarations"));
        }
        boolean b = super.processDeclarations(processor, substitutor, lastParent, place);
        if (b && lastParent != null && lastParent.getParent() == this && this.getParent() instanceof JSFile) {
            b = JSImportHandlingUtil.tryResolveImports(processor, (PsiNamedElement)this, place);
        }
        return b;
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        ASTNode node;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/ecmal4/impl/ActionScriptClassImpl", "addAfter"));
        }
        if (anchor == null && (node = this.getNode().findChildByType(JSTokenTypes.RBRACE)) != null) {
            PsiElement psiElement = super.addAfter(element, node.getTreePrev().getPsi());
            CodeStyleManager.getInstance((Project)this.getProject()).reformatNewlyAddedElement(this.getNode(), psiElement.getNode());
            return psiElement;
        }
        PsiElement psiElement = super.addAfter(element, anchor);
        CodeStyleManager.getInstance((Project)this.getProject()).reformatNewlyAddedElement(this.getNode(), psiElement.getNode());
        return psiElement;
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/ecmal4/impl/ActionScriptClassImpl", "addBefore"));
        }
        PsiElement superElement = super.addBefore(element, anchor);
        CodeStyleManager.getInstance((Project)this.getProject()).reformatNewlyAddedElement(this.getNode(), superElement.getNode());
        return superElement;
    }

    public boolean isEquivalentTo(PsiElement another) {
        return super.isEquivalentTo(another) || another instanceof JSFile && ((JSFile)another).getVirtualFile().getNameWithoutExtension().equals(this.getName()) && another == this.getParent().getParent() || JSPsiImplUtils.isTheSameClass(another, this);
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = JSPsiImplUtils.findTopLevelNavigatableElement(this);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/ActionScriptClassImpl", "getNavigationElement"));
        }
        return psiElement;
    }

    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = JSResolveUtil.findUseScope(this);
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/ActionScriptClassImpl", "getUseScope"));
        }
        return searchScope;
    }
}

