/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubbedStatementImpl;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.stubs.TypeScriptImportStatementStub;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptImportStatementImpl
extends JSStubbedStatementImpl<TypeScriptImportStatementStub>
implements TypeScriptImportStatement {
    public static final Key<String> RESOLVE_REF_ANCHOR = Key.create((String)"Import.Resolve.Ref.Key");
    private static final ThreadLocal<Set<String>> processingImportElementsHolder = new ThreadLocal<Set<String>>(){

        @Override
        protected Set<String> initialValue() {
            return ContainerUtil.newHashSet();
        }
    };
    private static final Key<ParameterizedCachedValue<Collection<? extends PsiElement>, TypeScriptImportStatementImpl>> CACHED_VALUE_KEY = Key.create((String)"TypeScript.Import.References");
    private static final ParameterizedCachedValueProvider<Collection<? extends PsiElement>, TypeScriptImportStatementImpl> CACHED_VALUE_PROVIDER = new ParameterizedCachedValueProvider<Collection<? extends PsiElement>, TypeScriptImportStatementImpl>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public CachedValueProvider.Result<Collection<? extends PsiElement>> compute(TypeScriptImportStatementImpl importStatement) {
            String key;
            String qualifiedName = importStatement.getQualifiedName();
            if (qualifiedName == null) {
                return CachedValueProvider.Result.create((Object)ContainerUtil.emptyList(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
            }
            Set processingElements = (Set)processingImportElementsHolder.get();
            if (processingElements.contains(key = importStatement.getProcessingElementKey())) {
                return CachedValueProvider.Result.create((Object)ContainerUtil.emptyList(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
            }
            processingElements.add(key);
            try {
                JSTypeResolveResult resolveResult = TypeScriptImportHandler.getInstance().resolveName(qualifiedName, (PsiElement)importStatement);
                CachedValueProvider.Result result = CachedValueProvider.Result.create(resolveResult.getElements(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
                return result;
            }
            finally {
                processingElements.remove(key);
            }
        }
    };

    public TypeScriptImportStatementImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptImportStatementImpl(TypeScriptImportStatementStub stub) {
        super(stub, (IStubElementType)TypeScriptElementTypes.IMPORT_STATEMENT);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptImportStatementImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitTypeScriptImportStatement((TypeScriptImportStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptImportStatementImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptImportStatementImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptImportStatementImpl", "processDeclarations"));
        }
        return processor.execute((PsiElement)this, state);
    }

    @Nullable
    public ASTNode findNameIdentifier() {
        return TypeScriptImportStatementImpl.findNameIdentifier(this.getNode());
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        ASTNode identifier = this.findNameIdentifier();
        return identifier != null ? identifier.getPsi() : null;
    }

    @Nullable
    public static ASTNode findNameIdentifier(@NotNull ASTNode importStatement) {
        if (importStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importStatement", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptImportStatementImpl", "findNameIdentifier"));
        }
        return importStatement.findChildByType(JSKeywordSets.TS_IDENTIFIERS_TOKENS_SET);
    }

    public String getName() {
        TypeScriptImportStatementStub stub = (TypeScriptImportStatementStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        ASTNode node = this.findNameIdentifier();
        if (node != null) {
            return node.getText();
        }
        return null;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptImportStatementImpl", "setName"));
        }
        ASTNode nameIdentifier = this.findNameIdentifier();
        if (nameIdentifier != null) {
            ASTNode identifier = JSChangeUtil.createNameIdentifier(this.getProject(), name, JavaScriptSupportLoader.TYPESCRIPT);
            nameIdentifier.getTreeParent().replaceChild(nameIdentifier, identifier);
        }
        return this;
    }

    public int getTextOffset() {
        ASTNode name = this.findNameIdentifier();
        return name != null ? name.getStartOffset() : super.getTextOffset();
    }

    @Nullable
    public JSAttributeList getAttributeList() {
        return (JSAttributeList)this.getStubOrPsiChild((IStubElementType)JSStubElementTypes.ATTRIBUTE_LIST);
    }

    public String getQualifiedName() {
        return JSPsiImplUtils.buildQualifiedNameFromNamespaceAndName((JSQualifiedNamedElement)this);
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        TypeScriptImportStatementStub stub = (TypeScriptImportStatementStub)this.getStub();
        if (stub != null) {
            return stub.getNamespace();
        }
        return JSPsiImplUtils.getNamespace((JSNamedElement)this);
    }

    public boolean isNamespaceExplicitlyDeclared() {
        return true;
    }

    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = JSContext.STATIC;
        if (jSContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptImportStatementImpl", "getJSContext"));
        }
        return jSContext;
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList list = this.getAttributeList();
        JSAttributeList.AccessType accessType = list != null ? list.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL;
        if (accessType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptImportStatementImpl", "getAccessType"));
        }
        return accessType;
    }

    public boolean isExported() {
        return ES6ImportHandler.calculateIsExported((PsiElement)this);
    }

    public boolean isDeprecated() {
        return false;
    }

    @Nullable
    public Icon getIcon(int flags) {
        return PlatformIcons.IMPORT_ICON;
    }

    @Nullable
    public TypeScriptEntityName getInternalModuleReference() {
        return (TypeScriptEntityName)this.getStubOrPsiChild((IStubElementType)TypeScriptElementTypes.ENTITY_NAME);
    }

    @Nullable
    public TypeScriptExternalModuleReference getExternalModuleReference() {
        return (TypeScriptExternalModuleReference)this.getStubOrPsiChild((IStubElementType)TypeScriptElementTypes.EXTERNAL_MODULE_REFERENCE);
    }

    @NotNull
    public Collection<? extends PsiElement> findReferencedElements() {
        Collection collection = (Collection)CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, CACHED_VALUE_KEY, CACHED_VALUE_PROVIDER, false, (Object)this);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptImportStatementImpl", "findReferencedElements"));
        }
        return collection;
    }

    protected String getProcessingElementKey() {
        String key = (String)this.getUserData(RESOLVE_REF_ANCHOR);
        if (key == null) {
            this.putUserData(RESOLVE_REF_ANCHOR, String.valueOf(((Object)((Object)this)).hashCode()));
        }
        key = (String)this.getUserData(RESOLVE_REF_ANCHOR);
        return key;
    }

    @NotNull
    public JSNamespace getJSNamespace() {
        JSNamespaceImpl jSNamespaceImpl = new JSNamespaceImpl(this.getNamespace(), this.getJSContext(), this.isNamespaceExplicitlyDeclared());
        if (jSNamespaceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptImportStatementImpl", "getJSNamespace"));
        }
        return jSNamespaceImpl;
    }
}

