/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecma6.impl.ES6FieldImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptVariableImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.stubs.JSVariableStub;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptFieldImpl
extends TypeScriptVariableImpl
implements TypeScriptField,
JSComputedPropertyNameOwner,
JSRecordType.PropertySignature {
    public TypeScriptFieldImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptFieldImpl(JSVariableStub<JSVariable> stub, JSStubElementType<JSVariableStub<JSVariable>, JSVariable> signature) {
        super(stub, signature);
    }

    @Override
    public boolean isConst() {
        JSVariableStub stub = (JSVariableStub)this.getStub();
        if (stub != null) {
            return stub.isConst();
        }
        JSAttributeList list = this.getAttributeList();
        if (list == null) {
            return false;
        }
        return list.hasModifier(JSAttributeList.ModifierType.READONLY);
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Nullable
    public ES6ComputedName getComputedPropertyName() {
        return (ES6ComputedName)this.getStubOrPsiChild((IStubElementType)ES6ElementTypes.COMPUTED_NAME);
    }

    @Override
    public boolean hasBlockScope() {
        return false;
    }

    @Override
    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        PsiElement parent = this.getParent();
        if (parent != null && parent.getParent() instanceof TypeScriptEnum) {
            JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PUBLIC;
            if (accessType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptFieldImpl", "getAccessType"));
            }
            return accessType;
        }
        JSAttributeList.AccessType accessType = super.getAccessType();
        if (accessType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptFieldImpl", "getAccessType"));
        }
        return accessType;
    }

    @Override
    public ASTNode findNameIdentifier() {
        if (this.getNode().findChildByType(JSTokenTypes.LBRACKET) != null) {
            return null;
        }
        return this.getNode().findChildByType(JSKeywordSets.PROPERTY_NAMES);
    }

    @Override
    protected JSType doGetDeclarationTypeStubSafe() {
        JSType type = super.doGetDeclarationTypeStubSafe();
        if (type != null) {
            return type;
        }
        type = this.getTypeFromEnum();
        if (type != null) {
            return type;
        }
        return null;
    }

    @Nullable
    private JSType getTypeFromEnum() {
        JSClass containingClass = this.getContainingClass();
        if (containingClass instanceof TypeScriptEnum) {
            String name = containingClass.getQualifiedName();
            if (StringUtil.isEmpty((String)name)) {
                return null;
            }
            return JSNamedType.createType(name, JSTypeSourceFactory.createTypeSource((PsiElement)this, true), JSContext.INSTANCE);
        }
        return null;
    }

    private JSClass getContainingClass() {
        return JSUtils.getMemberContainingClass((PsiElement)this);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptFieldImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptFieldImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptFieldImpl", "processDeclarations"));
        }
        if (ES6FieldImpl.skipElementsFromAttributeList((JSField)this, lastParent)) {
            return true;
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    public boolean isEquivalentTo(@Nullable JSRecordType.TypeMember other, boolean allowResolve) {
        return JSRecordType.arePropertySignaturesEqual((JSRecordType.PropertySignature)this, (JSRecordType.TypeMember)other, (boolean)allowResolve);
    }

    @Nullable
    public PsiElement getSource() {
        return this;
    }

    @NotNull
    public String getMemberName() {
        String string = TypeScriptPsiUtil.getMemberName(this);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptFieldImpl", "getMemberName"));
        }
        return string;
    }

    @NotNull
    public JSRecordType.PropertySignature copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform, boolean shouldCleanSourceElement) {
        if (childTransform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTransform", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptFieldImpl", "copyTypeHierarchy"));
        }
        JSRecordType.PropertySignature propertySignature = JSRecordTypeImpl.copyPropertySignature(this, childTransform, shouldCleanSourceElement);
        if (propertySignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptFieldImpl", "copyTypeHierarchy"));
        }
        return propertySignature;
    }

    public boolean isOptional() {
        return false;
    }
}

