/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.ecmascript6.psi.ES6FunctionProperty;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSContextExpectedTypeEvaluator;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSContextTypeEvaluator
extends JSContextExpectedTypeEvaluator {
    public JSContextTypeEvaluator(@NotNull JSExpression parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/psi/JSContextTypeEvaluator", "<init>"));
        }
        super(parent);
    }

    @Override
    protected JSContextExpectedTypeEvaluator newExpectedTypeEvaluator(JSExpression parent) {
        return new JSContextTypeEvaluator(parent);
    }

    public void visitJSBinaryExpression(JSBinaryExpression node) {
        JSType type;
        if (node.getOperationSign() == JSTokenTypes.OROR && (type = new JSContextTypeEvaluator((JSExpression)node).findExpectedType()) != null) {
            this.myResult = type;
        }
    }

    public void visitJSReturnStatement(JSReturnStatement node) {
        JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)this.myGrandParent, JSFunction.class);
        if (fun != null) {
            JSType type;
            JSType returnType = fun.getReturnType();
            if (returnType != null && !(returnType instanceof JSTypeofTypeImpl)) {
                JSTypeSource typeSource = returnType.getSource();
                if (typeSource.isExplicitlyDeclared()) {
                    this.myResult = returnType;
                }
            } else if (fun instanceof JSFunctionExpression && (type = new JSContextTypeEvaluator((JSExpression)((JSFunctionExpression)fun)).findExpectedType()) instanceof JSFunctionTypeImpl) {
                this.myResult = ((JSFunctionTypeImpl)type).getReturnType();
            }
        }
    }

    @Nullable
    public static JSType getTypeByFunctionParamIndex(JSFunctionTypeImpl funcType, int paramIndex) {
        JSParameterTypeDecorator lastParam;
        List<JSParameterTypeDecorator> funcTypeParameters = funcType.getParameters();
        JSType parameterType = null;
        if (paramIndex < funcTypeParameters.size()) {
            parameterType = funcTypeParameters.get(paramIndex).getType();
        }
        JSParameterTypeDecorator jSParameterTypeDecorator = lastParam = funcTypeParameters.size() > 0 ? funcTypeParameters.get(funcTypeParameters.size() - 1) : null;
        if (lastParam != null && lastParam.isRest()) {
            parameterType = lastParam.getType();
        }
        return parameterType;
    }

    @Nullable
    public static JSType getParameterType(@NotNull JSParameter parameter, @NotNull JSEvaluateContext evaluateContext) {
        JSNamespaceEvaluationResult initialization;
        JSParameter superParameter;
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/lang/javascript/psi/JSContextTypeEvaluator", "getParameterType"));
        }
        if (evaluateContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "com/intellij/lang/javascript/psi/JSContextTypeEvaluator", "getParameterType"));
        }
        JSType parameterType = null;
        JSFunction fun = parameter.getDeclaringFunction();
        if (fun != null && (superParameter = JSInheritanceUtil.findMatchedSuperParameter(parameter, fun)) != null) {
            parameterType = superParameter.getType();
        }
        if (parameterType == null && (fun instanceof JSFunctionExpression || fun instanceof ES6FunctionProperty)) {
            Collection<JSType> types;
            JSType funcType;
            PsiElement parentOfFunction = fun.getParent();
            if (fun instanceof ES6FunctionProperty) {
                funcType = null;
                if (parentOfFunction instanceof JSObjectLiteralExpression) {
                    JSRecordType.PropertySignature propertySignature;
                    JSType parentType = new JSContextTypeEvaluator((JSExpression)((JSObjectLiteralExpression)parentOfFunction)).findExpectedType();
                    String name = fun.getName();
                    if (parentType instanceof JSRecordType && name != null && (propertySignature = ((JSRecordType)parentType).findPropertySignature(name)) != null) {
                        funcType = propertySignature.getType();
                    }
                }
            } else {
                funcType = new JSContextTypeEvaluator((JSExpression)((JSFunctionExpression)fun)).findExpectedType();
            }
            if (!(types = JSTypeUtils.getFunctionType(funcType, false)).isEmpty()) {
                int paramIndex;
                JSInitializerOwner outerParameter = JSDestructuringUtil.findDestructuringParent((PsiElement)parameter, evaluateContext, (Condition<JSInitializerOwner>)((Condition)owner -> owner.getParent() instanceof JSParameterList));
                if (outerParameter == null) {
                    Logger.getInstance(JSContextTypeEvaluator.class).error("outerParameter not found: " + fun.getText());
                }
                JSParameterListElement[] parameters = fun.getParameters();
                for (paramIndex = 0; paramIndex < parameters.length && parameters[paramIndex] != outerParameter; ++paramIndex) {
                }
                if (paramIndex == parameters.length) {
                    Logger.getInstance(JSContextTypeEvaluator.class).error("paramIndex not found: " + fun.getText());
                }
                for (JSType type : types) {
                    JSExpression methodExpr;
                    if (!(type instanceof JSFunctionTypeImpl) || (parameterType = JSContextTypeEvaluator.getTypeByFunctionParamIndex((JSFunctionTypeImpl)type, paramIndex)) == null) continue;
                    PsiElement callExpr = parentOfFunction.getParent();
                    if (!(callExpr instanceof JSCallExpression) || !((methodExpr = ((JSCallExpression)callExpr).getMethodExpression()) instanceof JSReferenceExpression)) break;
                    PsiElement resolve = ((JSReferenceExpression)methodExpr).resolve();
                    parameterType = TypeScriptGenericTypesEvaluator.getInstance().evaluateGenerics(parameterType, methodExpr, resolve);
                    break;
                }
            }
            if (funcType != null && parameterType != null && funcType.getSource().isTypeScript() && !funcType.getSource().isExplicitlyDeclared()) {
                parameterType = JSTypeUtils.copyWithExplicitlyDeclared(parameterType, false);
            }
        }
        if (parameterType == null && fun instanceof JSFunctionExpression && fun.isAnonymousFunctionCall() && (initialization = JSSymbolUtil.getParameterInitialization(parameter)) != null) {
            parameterType = initialization.getSource() instanceof JSExpression && !initialization.isExplicitlyDeclared() ? JSResolveUtil.getExpressionJSType((JSExpression)initialization.getSource()) : initialization.toType((PsiElement)parameter);
        }
        return parameterType;
    }

    public void visitJSConditionalExpression(JSConditionalExpression node) {
        if (this.myParent == JSUtils.unparenthesize(node.getThen()) || this.myParent == JSUtils.unparenthesize(node.getElse())) {
            this.myResult = this.newExpectedTypeEvaluator((JSExpression)node).findExpectedType();
        }
    }
}

