/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.patterns;

import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.patterns.JSElementPattern;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.Nullable;

public class JSPatterns
extends PlatformPatterns {
    public static JSElementPattern.Capture<JSLiteralExpression> jsLiteralExpression() {
        return new JSElementPattern.Capture<JSLiteralExpression>(new InitialPatternCondition<JSLiteralExpression>(JSLiteralExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return o instanceof JSLiteralExpression;
            }
        });
    }

    public static JSElementPattern.Capture<JSExpression> jsArgument(String functionName, int index) {
        return JSPatterns.jsArgument(functionName, index, -1);
    }

    public static JSElementPattern.Capture<JSExpression> jsArgument(final String functionName, final int index, final int argCount) {
        return new JSElementPattern.Capture<JSExpression>(new InitialPatternCondition<JSExpression>(JSExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                if (!(o instanceof JSExpression)) {
                    return false;
                }
                PsiElement parent = ((JSExpression)o).getParent();
                if (!(parent instanceof JSArgumentList)) {
                    return false;
                }
                PsiElement parent1 = parent.getParent();
                if (!(parent1 instanceof JSCallExpression)) {
                    return false;
                }
                JSExpression methodExpression = ((JSCallExpression)parent1).getMethodExpression();
                if (!(methodExpression instanceof JSReferenceExpression)) {
                    return false;
                }
                String referencedName = ((JSReferenceExpression)methodExpression).getReferencedName();
                if (referencedName == null || !referencedName.equals(functionName)) {
                    return false;
                }
                PsiElement[] children = parent.getChildren();
                return (argCount == -1 || argCount == children.length) && index < children.length && children[index] == o;
            }
        });
    }

    public static JSElementPattern.Capture<JSExpression> asAssignedValue(final String propertyName, final String className, final String ... varNames) {
        return new JSElementPattern.Capture<JSExpression>(new InitialPatternCondition<JSExpression>(JSExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                if (!(o instanceof JSExpression)) {
                    return false;
                }
                PsiElement parent = ((JSExpression)o).getParent();
                if (!(parent instanceof JSAssignmentExpression)) {
                    return false;
                }
                if (parent.getContainingFile().getLanguage() != JavaScriptSupportLoader.ECMA_SCRIPT_L4) {
                    return false;
                }
                JSAssignmentExpression assignmentExpression = (JSAssignmentExpression)parent;
                if (assignmentExpression.getROperand() != o) {
                    return false;
                }
                JSExpression exp = assignmentExpression.getLOperand();
                if (!(exp instanceof JSDefinitionExpression)) {
                    return false;
                }
                if (!((exp = ((JSDefinitionExpression)exp).getExpression()) instanceof JSReferenceExpression)) {
                    return false;
                }
                JSReferenceExpression refExp = (JSReferenceExpression)exp;
                if (!propertyName.equals(refExp.getReferencedName())) {
                    return false;
                }
                if (varNames.length > 0) {
                    PsiElement firstChild = refExp.getFirstChild();
                    if (!(firstChild instanceof JSReferenceExpression)) {
                        return false;
                    }
                    if (ArrayUtil.find((Object[])varNames, (Object)((JSReferenceExpression)firstChild).getReferencedName()) < 0) {
                        return false;
                    }
                }
                if (className != null && className.length() > 0 && !className.equals("*")) {
                    PsiElement resolved = refExp.resolve();
                    if (!(resolved instanceof JSFunction) || !((JSFunction)resolved).isSetProperty()) {
                        return false;
                    }
                    PsiElement jsClass = resolved.getParent();
                    if (!(jsClass instanceof JSClass) || !className.equals(((JSClass)jsClass).getQualifiedName())) {
                        return false;
                    }
                }
                return true;
            }
        });
    }
}

