/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.navigation;

import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class JavaScriptSymbolContributor
implements ChooseByNameContributor {
    @NotNull
    public String[] getNames(Project project, boolean includeNonProjectItems) {
        JavaScriptIndex index = JavaScriptIndex.getInstance(project);
        String[] stringArray = index != null ? index.getSymbolNames() : ArrayUtil.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/navigation/JavaScriptSymbolContributor", "getNames"));
        }
        return stringArray;
    }

    @NotNull
    public NavigationItem[] getItemsByName(String name, String pattern, Project project, boolean includeNonProjectItems) {
        JavaScriptIndex index = JavaScriptIndex.getInstance(project);
        NavigationItem[] navigationItemArray = index != null ? index.getSymbolsByName(name, includeNonProjectItems) : NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY;
        if (navigationItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/navigation/JavaScriptSymbolContributor", "getItemsByName"));
        }
        return navigationItemArray;
    }
}

