/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.navigation;

import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaScriptRelatedProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/javascript/navigation/JavaScriptRelatedProvider", "getItems"));
        }
        PsiFile file = psiElement.getContainingFile();
        if (file instanceof JSFile) {
            LinkedHashSet<PsiElement> elements = new LinkedHashSet<PsiElement>();
            for (PsiElement element2 : file.getChildren()) {
                if (!(element2 instanceof ES6ImportDeclaration)) continue;
                int oldSize = elements.size();
                ES6ImportDeclaration declaration = (ES6ImportDeclaration)element2;
                for (ES6ImportedBinding eS6ImportedBinding : declaration.getImportedBindings()) {
                    elements.add(JSStubBasedPsiTreeUtil.calculateMeaningfulElement((PsiElement)eS6ImportedBinding));
                }
                for (ES6ImportedBinding eS6ImportedBinding : declaration.getImportSpecifiers()) {
                    elements.add(eS6ImportedBinding.resolve());
                }
                ES6FromClause clause = declaration.getFromClause();
                if (oldSize != elements.size() || clause == null) continue;
                elements.addAll(clause.resolveReferencedElements());
            }
            if (elements.size() > 0) {
                List list = ContainerUtil.mapNotNull(elements, element -> element != null ? new GotoRelatedItem(element) : null);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/navigation/JavaScriptRelatedProvider", "getItems"));
                }
                return list;
            }
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/navigation/JavaScriptRelatedProvider", "getItems"));
        }
        return list;
    }
}

