/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.nashorn.resolve;

import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public class NashornJSTypeEvaluator
extends JSTypeEvaluator {
    public NashornJSTypeEvaluator(JSEvaluateContext context, JSTypeProcessor processor) {
        super(context, processor, false);
    }

    @Override
    protected void evaluateCallExpressionTypes(JSCallExpression callExpression, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/nashorn/resolve/NashornJSTypeEvaluator", "evaluateCallExpressionTypes"));
        }
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (methodExpression instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, "Java", "type")) {
            JSLiteralExpression argument;
            Object value;
            JSExpression[] arguments = callExpression.getArguments();
            if (arguments.length == 1 && arguments[0] instanceof JSLiteralExpression && (value = (argument = (JSLiteralExpression)arguments[0]).getValue()) instanceof String) {
                PsiClass aClass;
                JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)callExpression.getProject());
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)callExpression);
                if (module != null && (aClass = psiFacade.findClass((String)value, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module))) != null) {
                    this.addType(JSNamedType.createType((String)value, JSTypeSourceFactory.createTypeSource((PsiElement)aClass, true), JSContext.STATIC), (PsiElement)aClass);
                    return;
                }
            }
        } else if (methodExpression instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, "Java", "extend")) {
            for (JSExpression argument : callExpression.getArguments()) {
                this.evaluateTypes(argument);
            }
            return;
        }
        super.evaluateCallExpressionTypes(callExpression, place);
    }
}

