/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import org.jetbrains.annotations.NotNull;

public class LocalReferenceResolver {
    @NotNull
    private final PsiFile myFile;

    public LocalReferenceResolver(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/modules/LocalReferenceResolver", "<init>"));
        }
        this.myFile = file;
    }

    public boolean checkResolveResults(@NotNull JSReferenceExpression node, ResolveResult[] resolveResults) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/modules/LocalReferenceResolver", "checkResolveResults"));
        }
        if (node.getReferenceName() == null) {
            return false;
        }
        if (resolveResults.length == 0) {
            return false;
        }
        for (ResolveResult result : resolveResults) {
            if (!result.isValidResult() || result.getElement() == null) continue;
            VirtualFile file = result.getElement().getContainingFile().getVirtualFile();
            if (!this.myFile.getVirtualFile().equals(file)) continue;
            return true;
        }
        return false;
    }
}

