/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.modules.InstallNodeLocalDependenciesAction;
import com.intellij.lang.javascript.modules.JSModulesQuickFix;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.NpmPackageInstallerLight;
import com.intellij.lang.javascript.modules.PackageJsonDocumentDependencies;
import com.intellij.lang.javascript.modules.RecordModuleIntoPackageJsonQuickFix;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.packaging.PackageManagementService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallNodeModuleQuickFix
implements LocalQuickFix,
HighPriorityAction,
HintAction,
JSModulesQuickFix {
    private final ModuleElement<? extends JSElement> myModuleElement;
    private final boolean myRecordIntoPackageJson;
    private final boolean myInstallAll;
    private final boolean myAsDevDependency;
    private final List<VirtualFile> myPackageJsonFiles;

    public InstallNodeModuleQuickFix(@NotNull ModuleElement<? extends JSElement> module, @NotNull Collection<VirtualFile> virtualFiles) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "<init>"));
        }
        if (virtualFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFiles", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "<init>"));
        }
        this(module, false, false, false, virtualFiles);
    }

    protected InstallNodeModuleQuickFix(@NotNull ModuleElement<? extends JSElement> module, boolean recordIntoPackageJson, boolean installAll, boolean asDevDependency, @NotNull Collection<VirtualFile> virtualFiles) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "<init>"));
        }
        if (virtualFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFiles", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "<init>"));
        }
        this.myModuleElement = module;
        this.myRecordIntoPackageJson = recordIntoPackageJson;
        this.myInstallAll = installAll;
        this.myAsDevDependency = asDevDependency;
        this.myPackageJsonFiles = new ArrayList<VirtualFile>(virtualFiles);
    }

    @Nls
    @NotNull
    public String getText() {
        String moduleName = this.myModuleElement.getModuleName();
        if (this.myRecordIntoPackageJson) {
            if (this.myAsDevDependency) {
                String string = JSBundle.message((String)"node.js.quickfix.install.node.module.with.dev.dependencies.text", (Object[])new Object[]{moduleName});
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "getText"));
                }
                return string;
            }
            String string = JSBundle.message((String)"node.js.quickfix.install.node.module.with.dependencies.text", (Object[])new Object[]{moduleName});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "getText"));
            }
            return string;
        }
        if (this.myInstallAll) {
            String option = this.myPackageJsonFiles.size() == 1 ? InstallNodeLocalDependenciesAction.guessNpmCommand(this.myPackageJsonFiles.get(0)).getCliOption() : "install";
            String string = JSBundle.message((String)"node.js.quickfix.run.npm.update.text", (Object[])new Object[]{option});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "getText"));
            }
            return string;
        }
        String string = JSBundle.message((String)"node.js.quickfix.install.node.module.text", (Object[])new Object[]{moduleName});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "getName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"node.js.quickfix.install.node.module.family.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "isAvailable"));
        }
        return !StringUtil.isEmptyOrSpaces((String)this.myModuleElement.getModuleName());
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "invoke"));
        }
        this.applyFixImpl(project, file);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "applyFix"));
        }
        this.applyFixImpl(project, descriptor.getPsiElement().getContainingFile());
    }

    private void applyFixImpl(@NotNull Project project, @NotNull PsiFile psiFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "applyFixImpl"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "applyFixImpl"));
        }
        InstallNodeModuleQuickFix.selectPackageJson(project, this.myPackageJsonFiles, (Consumer<VirtualFile>)((Consumer)packageJson -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "lambda$applyFixImpl$0"));
            }
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "lambda$applyFixImpl$0"));
            }
            this.invokeAction(project, psiFile, (VirtualFile)packageJson);
        }));
    }

    private void invokeAction(final @NotNull Project project, @NotNull PsiFile psiFile, @Nullable VirtualFile packageJson) {
        String extra;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "invokeAction"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "invokeAction"));
        }
        if (this.myInstallAll && packageJson != null) {
            InstallNodeLocalDependenciesAction.runAndShowConsole(project, packageJson);
            return;
        }
        NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance(project).getDefault();
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast(interpreter);
        if (localInterpreter == null) {
            Messages.showErrorDialog((Project)project, (String)JSBundle.message((String)"node.js.quickfix.install.node.module.error.no.interpreter.text", (Object[])new Object[0]), (String)JSBundle.message((String)"node.js.quickfix.install.node.module.error.no.interpreter.title", (Object[])new Object[0]));
            return;
        }
        if (this.myRecordIntoPackageJson) {
            if ((packageJson = InstallNodeModuleQuickFix.savePackageJson(project, packageJson)) == null) {
                return;
            }
            extra = this.myAsDevDependency ? "--save-dev" : "--save";
        } else {
            extra = null;
        }
        final String moduleName = this.myModuleElement.getModuleName();
        final PackageJsonDocumentDependencies packageJsonDocumentDependencies = PackageJsonDocumentDependencies.getInstance();
        packageJsonDocumentDependencies.startInstall(moduleName);
        DaemonCodeAnalyzer.getInstance((Project)project).restart(psiFile);
        PackageManagementService.Listener listener = new PackageManagementService.Listener(){

            public void operationStarted(String packageName) {
            }

            public void operationFinished(String packageName, @Nullable PackageManagementService.ErrorDescription errorDescription) {
                packageJsonDocumentDependencies.finishInstall(moduleName);
                if (errorDescription != null) {
                    Messages.showErrorDialog((Project)project, (String)JSBundle.message((String)"node.js.quickfix.install.node.module.error.prefix.text", (Object[])new Object[]{errorDescription.getMessage()}), (String)JSBundle.message((String)"node.js.quickfix.install.node.module.error.no.interpreter.title", (Object[])new Object[0]));
                }
            }
        };
        if (project.getBasePath() == null) {
            return;
        }
        NpmPackageInstallerLight installerLight = (NpmPackageInstallerLight)ServiceManager.getService(NpmPackageInstallerLight.class);
        UsageTrigger.trigger((String)"Npm.Packages.Install.Package.From.Package.Json");
        File workingDir = new File(packageJson == null ? project.getBasePath() : packageJson.getParent().getPath());
        installerLight.installPackage(project, localInterpreter, moduleName, null, workingDir, listener, extra);
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "showHint"));
        }
        return false;
    }

    private static VirtualFile savePackageJson(Project project, VirtualFile packageJson) {
        FileDocumentManager documentManager;
        Document document;
        PsiFile psiFile = RecordModuleIntoPackageJsonQuickFix.ensurePackageJsonExist(project, packageJson, null);
        VirtualFile virtualFile = packageJson = psiFile != null ? psiFile.getVirtualFile() : packageJson;
        if (packageJson != null && (document = (documentManager = FileDocumentManager.getInstance()).getDocument(packageJson)) != null) {
            documentManager.saveDocument(document);
        }
        return packageJson;
    }

    static void selectPackageJson(@NotNull Project project, @NotNull List<VirtualFile> packageJsonFiles, @NotNull Consumer<VirtualFile> consumer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "selectPackageJson"));
        }
        if (packageJsonFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJsonFiles", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "selectPackageJson"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "selectPackageJson"));
        }
        if ((packageJsonFiles = ContainerUtil.filter(packageJsonFiles, file -> file.isValid())).isEmpty()) {
            consumer.consume(null);
            return;
        }
        if (packageJsonFiles.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            consumer.consume(packageJsonFiles.get(0));
            return;
        }
        Collections.sort(packageJsonFiles, NodeModuleUtil.VIRTUAL_FILE_COMPARATOR);
        JBList list = new JBList();
        ArrayList<String> data = new ArrayList<String>();
        for (VirtualFile file2 : packageJsonFiles) {
            data.add(file2.getPath());
        }
        list.setListData(ArrayUtil.toObjectArray(data));
        List finalPackageJsonFiles = packageJsonFiles;
        JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Select package.json File").setItemChoosenCallback(() -> {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "lambda$selectPackageJson$2"));
            }
            int index = list.getSelectedIndex();
            if (index >= 0) {
                consumer.consume(finalPackageJsonFiles.get(index));
            }
        }).createPopup();
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor != null) {
            popup.showInBestPositionFor(editor);
        } else {
            popup.showCenteredInCurrentWindow(project);
        }
    }

    static abstract class ModuleElement<T extends JSElement> {
        protected final SmartPsiElementPointer<T> myPointer;

        public ModuleElement(@NotNull T element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix$ModuleElement", "<init>"));
            }
            this.myPointer = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
        }

        @Nullable
        public String getModuleName() {
            JSElement element = (JSElement)this.myPointer.getElement();
            if (element == null || !element.isValid()) {
                return null;
            }
            return this.getModuleNameImpl(element);
        }

        protected abstract String getModuleNameImpl(@NotNull T var1);
    }

    static class RequireModuleElement
    extends ModuleElement<JSLiteralExpression> {
        public RequireModuleElement(@NotNull JSLiteralExpression element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix$RequireModuleElement", "<init>"));
            }
            super(element);
        }

        @Override
        protected String getModuleNameImpl(@NotNull JSLiteralExpression element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix$RequireModuleElement", "getModuleNameImpl"));
            }
            return StringUtil.unquoteString((String)element.getText());
        }
    }

    static class ES6FromClauseModuleElement
    extends ModuleElement<ES6FromClause> {
        public ES6FromClauseModuleElement(@NotNull ES6FromClause element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix$ES6FromClauseModuleElement", "<init>"));
            }
            super(element);
        }

        @Override
        protected String getModuleNameImpl(@NotNull ES6FromClause element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix$ES6FromClauseModuleElement", "getModuleNameImpl"));
            }
            return StringUtil.unquoteString((String)StringUtil.notNullize((String)element.getReferenceText()));
        }
    }
}

