/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.intentions.CommentsMover;
import com.intellij.lang.javascript.modules.ImportJSModuleBaseFix;
import com.intellij.lang.javascript.modules.LastImportInScope;
import com.intellij.lang.javascript.modules.ModuleFixCreator;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class ImportCommonJSModuleFix
implements ImportJSModuleBaseFix,
LocalQuickFix,
HintAction,
HighPriorityAction {
    @NotNull
    protected final ModuleFixCreator.FixDescriptor myFixDescriptor;
    protected final boolean mySingleQuotes;
    private final SmartPsiElementPointer<JSReferenceExpression> myPointer;

    protected ImportCommonJSModuleFix(@NotNull JSReferenceExpression node, @NotNull ModuleFixCreator.FixDescriptor descriptor, boolean singleQuotes) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "<init>"));
        }
        this.mySingleQuotes = singleQuotes;
        this.myFixDescriptor = descriptor;
        this.myPointer = SmartPointerManager.getInstance((Project)node.getProject()).createSmartPsiElementPointer((PsiElement)node);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "invoke"));
        }
        JSReferenceExpression element = (JSReferenceExpression)this.myPointer.getElement();
        if (element != null) {
            this.invokeAction((PsiElement)element, editor);
        }
    }

    private void invokeAction(PsiElement element, Editor editor) {
        JSEmbeddedContent scope;
        JSEmbeddedContent embeddedContent = (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)element, JSEmbeddedContent.class, (boolean)false);
        boolean useEmbeddedContent = embeddedContent != null && (!DialectDetector.isJSX((PsiElement)embeddedContent) || !DialectDetector.isJSX((PsiElement)element.getContainingFile()));
        Object object = scope = useEmbeddedContent ? embeddedContent : element.getContainingFile();
        if (!(element instanceof JSReferenceExpression)) {
            return;
        }
        JSReferenceExpression reference = (JSReferenceExpression)element;
        if (!this.modifyExistingImports((PsiElement)scope, editor, reference)) {
            PsiElement last = new LastImportInScope(this.isPreferImportAnchor()).findAndSelect((PsiElement)scope, element);
            PsiElement created = this.createRequire(scope.getProject());
            if (last == null) {
                PsiElement child = scope.getFirstChild();
                if (child == null) {
                    scope.add(created);
                } else if (useEmbeddedContent) {
                    PsiFile dummyFile = ImportCommonJSModuleFix.createDummyFile(element.getProject(), "\n");
                    embeddedContent.addBefore(dummyFile.getFirstChild(), child);
                    scope.addBefore(created, child);
                } else {
                    scope.addBefore(created, child);
                }
            } else {
                PsiElement added = last.getParent().addAfter(created, last);
                if (last instanceof PsiComment) {
                    last.getParent().addBefore(CommentsMover.createNewLine(last), added);
                }
            }
            this.doSomethingWithCurrentFile(reference, editor);
        }
        DaemonCodeAnalyzer.getInstance((Project)scope.getProject()).restart(element.getContainingFile());
    }

    protected abstract boolean modifyExistingImports(@NotNull PsiElement var1, Editor var2, @NotNull JSReferenceExpression var3);

    protected void doSomethingWithCurrentFile(JSReferenceExpression element, Editor editor) {
        String[] tail = this.myFixDescriptor.getTail();
        if (tail == null || tail.length == 0) {
            return;
        }
        this.doSomethingWithCurrentFile(element, editor, tail[tail.length - 1]);
    }

    protected void doSomethingWithCurrentFile(JSReferenceExpression element, Editor editor, @NotNull String newReferenceName) {
        if (newReferenceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newReferenceName", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "doSomethingWithCurrentFile"));
        }
        PsiFile dummy = ImportCommonJSModuleFix.createDummyFile(element.getProject(), newReferenceName);
        PsiElement replace = element.replace(dummy.getFirstChild());
        if (editor != null) {
            editor.getCaretModel().moveToOffset(replace.getTextRange().getEndOffset());
        }
    }

    protected abstract boolean isPreferImportAnchor();

    protected abstract PsiElement createRequire(Project var1);

    protected static PsiFile createDummyFile(Project project, String text) {
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project);
        return psiFileFactory.createFileFromText("dummy." + JavaScriptFileType.INSTANCE.getDefaultExtension(), (FileType)JavaScriptFileType.INSTANCE, (CharSequence)text);
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "showHint"));
        }
        return false;
    }

    public String getPath() {
        return this.myFixDescriptor.getFromPath();
    }

    @Override
    public String getVarName() {
        if (this.myFixDescriptor.getTail() != null) {
            String[] tail = this.myFixDescriptor.getTail();
            return tail[tail.length - 1];
        }
        return this.myFixDescriptor.getFirstWordInFile();
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "getName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        if (element instanceof JSReferenceExpression) {
            this.invokeAction(element, null);
        }
    }
}

