/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.idea.RareLogger;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterErrorBase;
import com.intellij.lang.javascript.linter.tslint.TSLinterError;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.util.text.CharSequenceReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class TsLintOutputParser
implements ProcessListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.linter.tslint.TsLint");
    private static final Logger RARE_LOGGER = RareLogger.wrap((Logger)LOG, (boolean)false);
    private final String myPath;
    private final boolean myZeroBasedRowCol;
    private final ArrayList<JSLinterError> myErrors;
    private final StringBuilder myGlobalError;
    private final StringBuilder myText;

    public TsLintOutputParser(String path, boolean zeroBasedRowCol) {
        this.myPath = path;
        this.myZeroBasedRowCol = zeroBasedRowCol;
        this.myErrors = new ArrayList();
        this.myGlobalError = new StringBuilder();
        this.myText = new StringBuilder();
    }

    public void startNotified(ProcessEvent event) {
    }

    public void processTerminated(ProcessEvent event) {
    }

    public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
    }

    public void onTextAvailable(ProcessEvent event, Key outputType) {
        String text = event.getText().trim();
        if (outputType == ProcessOutputTypes.STDERR) {
            this.myGlobalError.append(text).append("\n");
        } else if (outputType == ProcessOutputTypes.STDOUT) {
            this.myText.append(text).append("\n");
        }
    }

    public void process() {
        JsonElement root;
        try {
            root = new JsonParser().parse((Reader)new CharSequenceReader((CharSequence)this.myText));
        }
        catch (JsonIOException e) {
            RARE_LOGGER.info(((Object)((Object)e)).getClass().getName() + " when parsing tslint output: " + this.myText, (Throwable)e);
            return;
        }
        catch (JsonSyntaxException e) {
            RARE_LOGGER.info(((Object)((Object)e)).getClass().getName() + " when parsing tslint output: " + this.myText, (Throwable)e);
            return;
        }
        if (root instanceof JsonNull) {
            return;
        }
        if (!root.isJsonArray()) {
            this.logError("root element is not array");
            return;
        }
        JsonArray array = root.getAsJsonArray();
        int size = array.size();
        for (int i = 0; i < size; ++i) {
            JsonElement element = array.get(i);
            if (!element.isJsonObject()) {
                this.logError("element under root is not object");
                return;
            }
            JsonObject object = element.getAsJsonObject();
            this.processError(object);
        }
    }

    private void processError(JsonObject object) {
        JsonElement name = object.get("name");
        if (name == null) {
            this.logError("no name for error object");
            return;
        }
        JsonElement failure = object.get("failure");
        if (failure == null || !failure.isJsonPrimitive() || !failure.getAsJsonPrimitive().isString()) {
            this.logError("no failure for error object");
            return;
        }
        JsonElement startPosition = object.get("startPosition");
        if (startPosition == null || !startPosition.isJsonObject()) {
            this.logError("no startPosition for error object");
            return;
        }
        JsonElement endPosition = object.get("endPosition");
        if (endPosition == null || !endPosition.isJsonObject()) {
            this.logError("no endPosition for error object");
            return;
        }
        JsonElement ruleName = object.get("ruleName");
        if (ruleName == null || !ruleName.isJsonPrimitive() || !ruleName.getAsJsonPrimitive().isString()) {
            this.logError("no rule name for error object");
            return;
        }
        Pair<Integer, Integer> start = this.parseLineColumn(startPosition.getAsJsonObject());
        Pair<Integer, Integer> end = this.parseLineColumn(endPosition.getAsJsonObject());
        if (start == null || end == null) {
            return;
        }
        this.myErrors.add(new TSLinterError((Integer)start.getFirst(), (Integer)start.getSecond(), failure.getAsString(), ruleName.getAsString(), (Integer)end.getFirst(), (Integer)end.getSecond()));
    }

    private Pair<Integer, Integer> parseLineColumn(JsonObject position) {
        JsonElement line = position.get("line");
        if (line == null || !line.isJsonPrimitive() || !line.getAsJsonPrimitive().isNumber()) {
            this.logError("no line for position");
            return null;
        }
        JsonElement character = position.get("character");
        if (character == null || !character.isJsonPrimitive() || !character.getAsJsonPrimitive().isNumber()) {
            this.logError("no line for position");
            return null;
        }
        if (this.myZeroBasedRowCol) {
            return Pair.create((Object)line.getAsJsonPrimitive().getAsInt(), (Object)character.getAsJsonPrimitive().getAsInt());
        }
        return Pair.create((Object)(line.getAsJsonPrimitive().getAsInt() + 1), (Object)(character.getAsJsonPrimitive().getAsInt() + 1));
    }

    private void logError(String error) {
        LOG.info("Error when parsing tslint file: " + error + ", file: " + this.myPath + ", text: " + this.myText);
    }

    public JSLinterErrorBase getGlobalError() {
        return this.myGlobalError.length() == 0 ? null : new JSLinterError(0, 0, this.myGlobalError.toString(), null);
    }

    public List<JSLinterError> getErrors() {
        return this.myErrors;
    }
}

