/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import java.io.File;

public class TsLintConfigFileSearcher {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.linter.tslint.TsLint");
    public static final String CONFIG_FILE_NAME = "tslint.json";

    public VirtualFile lookup(VirtualFile vf) {
        VirtualFile virtualFile;
        for (VirtualFile current = vf.getParent(); current != null; current = current.getParent()) {
            VirtualFile child = current.findChild(CONFIG_FILE_NAME);
            if (child == null) continue;
            return child;
        }
        File file = new File(SystemProperties.getUserHome());
        if (file.exists() && (virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file)) == null) {
            LOG.debug("Could not find virtual file for config file, though config file exists: " + file.getAbsolutePath());
        }
        return null;
    }
}

