/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.rhino;

import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptableObject;

public class RhinoUtil {
    private RhinoUtil() {
    }

    @NotNull
    public static Object toRhinoAnyNotNull(@NotNull Object object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/lang/javascript/linter/rhino/RhinoUtil", "toRhinoAnyNotNull"));
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            NativeObject nativeObject = RhinoUtil.toRhinoMap(map);
            if (nativeObject == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/rhino/RhinoUtil", "toRhinoAnyNotNull"));
            }
            return nativeObject;
        }
        if (object instanceof Number || object instanceof Boolean || object instanceof String) {
            Object object2 = object;
            if (object2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/rhino/RhinoUtil", "toRhinoAnyNotNull"));
            }
            return object2;
        }
        if (object instanceof List) {
            NativeArray nativeArray = RhinoUtil.toRhinoArray((List)object);
            if (nativeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/rhino/RhinoUtil", "toRhinoAnyNotNull"));
            }
            return nativeArray;
        }
        if (object instanceof Object[]) {
            throw new RuntimeException("Java arrays aren't supported, please use " + List.class);
        }
        throw new RuntimeException("Unexpected rhino object " + object);
    }

    @Nullable
    public static Object toRhinoAny(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        return RhinoUtil.toRhinoAnyNotNull(object);
    }

    public static NativeArray toRhinoArray(@NotNull List<Object> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/lang/javascript/linter/rhino/RhinoUtil", "toRhinoArray"));
        }
        Object[] resArray = new Object[list.size()];
        int i = 0;
        for (Object o : list) {
            Object res;
            resArray[i] = res = RhinoUtil.toRhinoAny(o);
            ++i;
        }
        return new NativeArray(resArray);
    }

    @NotNull
    public static NativeObject toRhinoMap(@NotNull Map<String, ?> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/lang/javascript/linter/rhino/RhinoUtil", "toRhinoMap"));
        }
        NativeObject object = new NativeObject();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            Object nativeObj = RhinoUtil.toRhinoAny(entry.getValue());
            object.defineProperty(entry.getKey(), nativeObj, 1);
        }
        NativeObject nativeObject = object;
        if (nativeObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/rhino/RhinoUtil", "toRhinoMap"));
        }
        return nativeObject;
    }

    @Nullable
    public static Object toJavaAny(@Nullable Object rhinoObject) {
        if (rhinoObject instanceof NativeObject) {
            return RhinoUtil.toJavaMap((NativeObject)rhinoObject);
        }
        if (rhinoObject instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)rhinoObject;
            return Arrays.asList(nativeArray.toArray());
        }
        return rhinoObject;
    }

    @NotNull
    public static Map<Object, Object> toJavaMap(@NotNull NativeObject nativeObject) {
        if (nativeObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeObject", "com/intellij/lang/javascript/linter/rhino/RhinoUtil", "toJavaMap"));
        }
        HashMap copy = ContainerUtil.newHashMap();
        for (Map.Entry entry : nativeObject.entrySet()) {
            Object regularKey = RhinoUtil.toJavaAny(entry.getKey());
            Object regularValue = RhinoUtil.toJavaAny(entry.getValue());
            copy.put(regularKey, regularValue);
        }
        HashMap hashMap = copy;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/rhino/RhinoUtil", "toJavaMap"));
        }
        return hashMap;
    }

    @Nullable
    public static String getStringKey(@NotNull ScriptableObject object, @NotNull String key) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/lang/javascript/linter/rhino/RhinoUtil", "getStringKey"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/javascript/linter/rhino/RhinoUtil", "getStringKey"));
        }
        Object value = object.get((Object)key);
        String str = null;
        if (value instanceof String) {
            str = (String)value;
        } else if (value instanceof ConsString) {
            ConsString consString = (ConsString)value;
            str = consString.toString();
        }
        return str;
    }
}

