/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.option;

import com.intellij.lang.javascript.linter.jshint.JSHintUtil;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionEnumVariant {
    private final Object myValue;
    private final String myValueAsJsonStr;
    private final String myValueDescription;

    public OptionEnumVariant(@NotNull Object value, @NotNull String valueDescription) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/javascript/linter/option/OptionEnumVariant", "<init>"));
        }
        if (valueDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueDescription", "com/intellij/lang/javascript/linter/option/OptionEnumVariant", "<init>"));
        }
        this.myValue = value;
        this.myValueDescription = valueDescription;
        this.myValueAsJsonStr = OptionEnumVariant.toJsonPrimitive(value);
    }

    @NotNull
    public Object getValue() {
        Object object = this.myValue;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/option/OptionEnumVariant", "getValue"));
        }
        return object;
    }

    @NotNull
    public String getValueDescription() {
        String string = this.myValueDescription;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/option/OptionEnumVariant", "getValueDescription"));
        }
        return string;
    }

    @NotNull
    private static String toJsonPrimitive(@NotNull Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/javascript/linter/option/OptionEnumVariant", "toJsonPrimitive"));
        }
        if (value instanceof Boolean) {
            String string = value.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/option/OptionEnumVariant", "toJsonPrimitive"));
            }
            return string;
        }
        if (value instanceof String) {
            String string = StringUtil.wrapWithDoubleQuote((String)value.toString());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/option/OptionEnumVariant", "toJsonPrimitive"));
            }
            return string;
        }
        throw new RuntimeException("Unexpected value: " + value);
    }

    @NotNull
    public String getValueAsJsonStr() {
        String string = this.myValueAsJsonStr;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/option/OptionEnumVariant", "getValueAsJsonStr"));
        }
        return string;
    }

    @Nullable
    public static OptionEnumVariant cast(@Nullable Object obj) {
        return JSHintUtil.cast(obj, OptionEnumVariant.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptionEnumVariant variant = (OptionEnumVariant)o;
        return this.myValue.equals(variant.myValue);
    }

    public int hashCode() {
        return this.myValue.hashCode();
    }

    public String toString() {
        return this.myValueAsJsonStr;
    }
}

