/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jslint;

import com.google.common.collect.Maps;
import com.intellij.lang.javascript.linter.jslint.JSLintOption;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLintOptionsState {
    private final Map<JSLintOption, Object> myValueByOptionMap;

    private JSLintOptionsState(@NotNull Map<JSLintOption, Object> valueByOptionMap) {
        if (valueByOptionMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueByOptionMap", "com/intellij/lang/javascript/linter/jslint/JSLintOptionsState", "<init>"));
        }
        this.myValueByOptionMap = Maps.newEnumMap(valueByOptionMap);
    }

    @NotNull
    public Set<JSLintOption> getOptions() {
        Set<JSLintOption> set = this.myValueByOptionMap.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jslint/JSLintOptionsState", "getOptions"));
        }
        return set;
    }

    @Nullable
    public Object getValue(@NotNull JSLintOption option) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/linter/jslint/JSLintOptionsState", "getValue"));
        }
        return this.myValueByOptionMap.get((Object)option);
    }

    public boolean getBoolean(@NotNull JSLintOption option) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/linter/jslint/JSLintOptionsState", "getBoolean"));
        }
        Object obj = this.myValueByOptionMap.get((Object)option);
        if (obj == null) {
            return false;
        }
        return (Boolean)obj;
    }

    public int getIntValue(@NotNull JSLintOption option, int defaultValue) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/linter/jslint/JSLintOptionsState", "getIntValue"));
        }
        if (option.getType() != JSLintOption.Type.INTEGER) {
            throw new RuntimeException("option " + (Object)((Object)option) + " is not an integer option");
        }
        Object obj = this.myValueByOptionMap.get((Object)option);
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        throw new RuntimeException((Object)((Object)option) + " option has value " + obj + " of class " + obj.getClass());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSLintOptionsState that = (JSLintOptionsState)o;
        return this.myValueByOptionMap.equals(that.myValueByOptionMap);
    }

    public int hashCode() {
        return this.myValueByOptionMap.hashCode();
    }

    public String toString() {
        return this.myValueByOptionMap.toString();
    }

    public static class Builder {
        private final EnumMap<JSLintOption, Object> myValueByOptionMap;

        public Builder() {
            this.myValueByOptionMap = Maps.newEnumMap(JSLintOption.class);
        }

        public Builder(@NotNull JSLintOptionsState optionsState) {
            if (optionsState == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionsState", "com/intellij/lang/javascript/linter/jslint/JSLintOptionsState$Builder", "<init>"));
            }
            this.myValueByOptionMap = Maps.newEnumMap((Map)optionsState.myValueByOptionMap);
        }

        public Builder put(@NotNull JSLintOption option, @NotNull Object value) {
            if (option == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/linter/jslint/JSLintOptionsState$Builder", "put"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/javascript/linter/jslint/JSLintOptionsState$Builder", "put"));
            }
            JSLintOption.Type optionType = option.getType();
            if (!optionType.isProperValue(value)) {
                String message = String.format("Attempt to set value of JSLint option '%s' to '%s' (value class is %s)!", option.getOptionName(), value, value.getClass());
                throw new RuntimeException(message);
            }
            Object prevValue = this.myValueByOptionMap.get((Object)option);
            if (prevValue != null || !optionType.isDefault(value)) {
                this.myValueByOptionMap.put(option, value);
            }
            return this;
        }

        @NotNull
        public JSLintOptionsState build() {
            JSLintOptionsState jSLintOptionsState = new JSLintOptionsState(this.myValueByOptionMap);
            if (jSLintOptionsState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jslint/JSLintOptionsState$Builder", "build"));
            }
            return jSLintOptionsState;
        }
    }
}

