/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jslint;

import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum JSLintOption {
    BITWISE(Type.BOOLEAN, "Tolerate bitwise operators", "check if bitwise operators should be allowed"),
    BROWSER(Type.BOOLEAN, "Assume a browser", "check if the standard browser globals should be predefined"),
    COUCH(Type.BOOLEAN, "Assume CouchDB", "check if Couch DB globals should be predefined"),
    DEVEL(Type.BOOLEAN, "Assume in development", "check if browser globals that are useful in development should be predefined"),
    ES6(Type.BOOLEAN, "ES6", "check if using the good parts of ECMAScript Sixth Edition, it adds ES6 globals"),
    EVAL(Type.BOOLEAN, "Tolerate eval", "check if eval should be allowed"),
    FOR(Type.BOOLEAN, "Tolerate for statement", "check if for statement should be allowed"),
    MAXERR(Type.INTEGER, "Maximum number of errors", "Maximum number of warnings reported"),
    MAXLEN(Type.INTEGER, "Maximum line length", "Maximum number of characters in a line"),
    MULTIVAR(Type.BOOLEAN, "multiple vars", "check if a var, let, or const statement can declare two or more variables in a single statement"),
    NODE(Type.BOOLEAN, "Assume Node.js", "check if Node.js globals should be predefined"),
    GLOBALS(Type.STRING, "Globals ( , separated)", "An array of strings, the names of predefined global variables, or an object whose keys are global variable names, and whose values are booleans that determine if each variable is assignable. predef is used with the option object, but not with the /*jslint */ directive. You can also use the var statement to declare global variables in a script file."),
    SINGLE(Type.BOOLEAN, "Tolerate single quote strings", "check if ' (single quote) should be allowed to enclose string literals"),
    THIS(Type.BOOLEAN, "Tolerate this", "check if this should be allowed"),
    WHITE(Type.BOOLEAN, "Tolerate whitespace mess", "check if the whitespace rules should be ignored");

    private final String myOptionName;
    private final Type myType;
    private final String myDescription;
    private final String myMeaning;
    private static final ImmutableMap<String, JSLintOption> OPTION_BY_NAME_MAP;

    private JSLintOption(@NotNull Type type, String description, String meaning) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/linter/jslint/JSLintOption", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/lang/javascript/linter/jslint/JSLintOption", "<init>"));
        }
        if (meaning == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meaning", "com/intellij/lang/javascript/linter/jslint/JSLintOption", "<init>"));
        }
        this.myOptionName = this.name().toLowerCase(Locale.US);
        this.myType = type;
        this.myDescription = description;
        this.myMeaning = meaning;
    }

    @NotNull
    public Type getType() {
        Type type = this.myType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jslint/JSLintOption", "getType"));
        }
        return type;
    }

    @NotNull
    public String getOptionName() {
        String string = this.myOptionName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jslint/JSLintOption", "getOptionName"));
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jslint/JSLintOption", "getDescription"));
        }
        return string;
    }

    @NotNull
    public String getMeaning() {
        String string = this.myMeaning;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jslint/JSLintOption", "getMeaning"));
        }
        return string;
    }

    @Nullable
    public static JSLintOption findByName(@NotNull String optionName) {
        if (optionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionName", "com/intellij/lang/javascript/linter/jslint/JSLintOption", "findByName"));
        }
        return (JSLintOption)((Object)OPTION_BY_NAME_MAP.get((Object)optionName));
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (JSLintOption option : JSLintOption.values()) {
            builder.put((Object)option.getOptionName(), (Object)option);
        }
        OPTION_BY_NAME_MAP = builder.build();
    }

    public static enum Type {
        BOOLEAN((Class)Boolean.class){

            @Override
            public Boolean createObject(@NotNull String valueStr) {
                if (valueStr == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueStr", "com/intellij/lang/javascript/linter/jslint/JSLintOption$Type$1", "createObject"));
                }
                return Boolean.parseBoolean(valueStr);
            }

            @Override
            public boolean isDefault(@NotNull Object value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/javascript/linter/jslint/JSLintOption$Type$1", "isDefault"));
                }
                return value == Boolean.FALSE;
            }
        }
        ,
        STRING((Class)String.class){

            @Override
            public String createObject(@NotNull String valueStr) {
                if (valueStr == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueStr", "com/intellij/lang/javascript/linter/jslint/JSLintOption$Type$2", "createObject"));
                }
                return valueStr;
            }

            @Override
            public boolean isDefault(@NotNull Object value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/javascript/linter/jslint/JSLintOption$Type$2", "isDefault"));
                }
                return "".equals(value);
            }
        }
        ,
        INTEGER((Class)Integer.class){

            @Override
            public Integer createObject(@NotNull String valueStr) {
                if (valueStr == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueStr", "com/intellij/lang/javascript/linter/jslint/JSLintOption$Type$3", "createObject"));
                }
                try {
                    return Integer.parseInt(valueStr);
                }
                catch (Exception e) {
                    return null;
                }
            }

            @Override
            public boolean isDefault(@NotNull Object value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/javascript/linter/jslint/JSLintOption$Type$3", "isDefault"));
                }
                return false;
            }

            @Override
            public boolean isProperValue(@Nullable Object obj) {
                if (obj == null) {
                    return true;
                }
                if (obj instanceof Integer || obj instanceof Long) {
                    Number n = (Number)obj;
                    return n.intValue() >= 0;
                }
                return false;
            }
        };

        private final Class<?> myClass;

        private Type(Class<?> clazz) {
            this.myClass = clazz;
        }

        @Nullable
        public abstract Object createObject(@NotNull String var1);

        public abstract boolean isDefault(@NotNull Object var1);

        public boolean isProperValue(@Nullable Object obj) {
            return obj == null || this.myClass.isInstance(obj);
        }
    }
}

