/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint.config;

import com.google.gson.stream.JsonReader;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.jshint.JSHintOption;
import com.intellij.lang.javascript.linter.jshint.JSHintOptionsState;
import com.intellij.lang.javascript.linter.jshint.config.JSHintConfigFileUtil;
import com.intellij.lang.javascript.linter.jshint.config.JSHintConfigLookupResult;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintConfigParser {
    private static final Logger LOG = Logger.getInstance(JSHintConfigParser.class);
    private final Set<VirtualFile> myParsedFiles = ContainerUtil.newHashSet();

    private JSHintConfigParser() {
    }

    @NotNull
    private JSHintConfigLookupResult doParse(@NotNull VirtualFile config) {
        JSHintOptionsState optionsState;
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigParser", "doParse"));
        }
        if (this.myParsedFiles.contains(config)) {
            JSHintConfigLookupResult jSHintConfigLookupResult = JSHintConfigLookupResult.createErrorResult(config, JSBundle.message((String)"jshint.config.extends.cyclically", (Object[])new Object[0]));
            if (jSHintConfigLookupResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigParser", "doParse"));
            }
            return jSHintConfigLookupResult;
        }
        this.myParsedFiles.add(config);
        try {
            String text = JSLinterConfigFileUtil.loadActualText(config);
            optionsState = JSHintConfigParser.parseOptionsState(text);
        }
        catch (IOException e) {
            LOG.info("Cannot parse jshint config at " + config.getPath(), (Throwable)e);
            JSHintConfigLookupResult jSHintConfigLookupResult = JSHintConfigLookupResult.createErrorResult(config, JSBundle.message((String)"jshint.config.failed.to.read", (Object[])new Object[0]));
            if (jSHintConfigLookupResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigParser", "doParse"));
            }
            return jSHintConfigLookupResult;
        }
        Object extendsObj = optionsState.getValue("extends");
        if (extendsObj == null) {
            JSHintConfigLookupResult jSHintConfigLookupResult = JSHintConfigLookupResult.createSuccessfulResult(config, optionsState);
            if (jSHintConfigLookupResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigParser", "doParse"));
            }
            return jSHintConfigLookupResult;
        }
        JSHintConfigLookupResult extendedResult = this.doParseExtended(config, extendsObj);
        if (extendedResult.getErrorMessage() != null) {
            JSHintConfigLookupResult jSHintConfigLookupResult = extendedResult;
            if (jSHintConfigLookupResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigParser", "doParse"));
            }
            return jSHintConfigLookupResult;
        }
        JSHintOptionsState extendedOptionsState = extendedResult.getOptionsState();
        if (extendedOptionsState == null) {
            LOG.warn("JSHint extended options state is null unexpectedly");
            JSHintConfigLookupResult jSHintConfigLookupResult = JSHintConfigLookupResult.createSuccessfulResult(config, optionsState);
            if (jSHintConfigLookupResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigParser", "doParse"));
            }
            return jSHintConfigLookupResult;
        }
        JSHintOptionsState mergedOptionsState = JSHintConfigParser.merge(optionsState, extendedOptionsState);
        JSHintConfigLookupResult jSHintConfigLookupResult = JSHintConfigLookupResult.createSuccessfulResult(config, mergedOptionsState);
        if (jSHintConfigLookupResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigParser", "doParse"));
        }
        return jSHintConfigLookupResult;
    }

    @NotNull
    private static JSHintOptionsState merge(@NotNull JSHintOptionsState optionsState, @NotNull JSHintOptionsState extendedOptionsState) {
        if (optionsState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionsState", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigParser", "merge"));
        }
        if (extendedOptionsState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extendedOptionsState", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigParser", "merge"));
        }
        JSHintOptionsState.Builder builder = new JSHintOptionsState.Builder();
        for (String key : extendedOptionsState.getOptionKeys()) {
            if ("extends".equals(key)) continue;
            builder.put(key, extendedOptionsState.getValue(key));
        }
        for (String key : optionsState.getOptionKeys()) {
            if ("extends".equals(key)) continue;
            builder.put(key, optionsState.getValue(key));
        }
        Map<String, Boolean> mergedGlobals = JSHintConfigParser.mergeGlobals(extendedOptionsState.getValue(JSHintOption.PREDEF), optionsState.getValue(JSHintOption.PREDEF));
        if (mergedGlobals != null) {
            builder.put(JSHintOption.PREDEF, mergedGlobals);
        }
        JSHintOptionsState jSHintOptionsState = builder.build();
        if (jSHintOptionsState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigParser", "merge"));
        }
        return jSHintOptionsState;
    }

    @Nullable
    private static Map<String, Boolean> mergeGlobals(@Nullable Object extendedGlobals, @Nullable Object globals) {
        if (extendedGlobals == null || globals == null) {
            return null;
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        JSHintConfigParser.overwriteGlobals(result, extendedGlobals);
        JSHintConfigParser.overwriteGlobals(result, globals);
        return result;
    }

    private static void overwriteGlobals(@NotNull Map<String, Boolean> result, @Nullable Object globals) {
        block4: {
            block3: {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigParser", "overwriteGlobals"));
                }
                if (!(globals instanceof List)) break block3;
                List list = (List)globals;
                for (Object o : list) {
                    if (!(o instanceof String)) continue;
                    result.put((String)o, false);
                }
                break block4;
            }
            if (!(globals instanceof Map)) break block4;
            Map map = (Map)globals;
            for (Map.Entry entry : map.entrySet()) {
                if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof Boolean)) continue;
                result.put((String)entry.getKey(), (Boolean)entry.getValue());
            }
        }
    }

    @NotNull
    private JSHintConfigLookupResult doParseExtended(@NotNull VirtualFile config, @NotNull Object extendsObj) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigParser", "doParseExtended"));
        }
        if (extendsObj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extendsObj", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigParser", "doParseExtended"));
        }
        if (extendsObj instanceof String) {
            String extendsPath = (String)extendsObj;
            VirtualFile configDir = config.getParent();
            if (configDir == null) {
                JSHintConfigLookupResult jSHintConfigLookupResult = JSHintConfigLookupResult.createErrorResult(config, "JSHint: cannot locate extended config");
                if (jSHintConfigLookupResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigParser", "doParseExtended"));
                }
                return jSHintConfigLookupResult;
            }
            VirtualFile extendedFile = configDir.findFileByRelativePath(extendsPath);
            if (extendedFile != null && extendedFile.isValid() && !extendedFile.isDirectory()) {
                JSHintConfigLookupResult jSHintConfigLookupResult = this.doParse(extendedFile);
                if (jSHintConfigLookupResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigParser", "doParseExtended"));
                }
                return jSHintConfigLookupResult;
            }
        }
        JSHintConfigLookupResult jSHintConfigLookupResult = JSHintConfigLookupResult.createErrorResult(config, "JSHint: cannot parse extended config");
        if (jSHintConfigLookupResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigParser", "doParseExtended"));
        }
        return jSHintConfigLookupResult;
    }

    @NotNull
    private static JSHintOptionsState parseOptionsState(@NotNull String text) throws IOException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigParser", "parseOptionsState"));
        }
        JsonReader reader = new JsonReader((Reader)new StringReader(text));
        reader.setLenient(true);
        JSHintOptionsState jSHintOptionsState = JSHintConfigFileUtil.parseOptionsState(reader);
        if (jSHintOptionsState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigParser", "parseOptionsState"));
        }
        return jSHintOptionsState;
    }

    @NotNull
    public static JSHintConfigLookupResult parse(@NotNull VirtualFile config) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigParser", "parse"));
        }
        JSHintConfigLookupResult jSHintConfigLookupResult = new JSHintConfigParser().doParse(config);
        if (jSHintConfigLookupResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigParser", "parse"));
        }
        return jSHintConfigLookupResult;
    }
}

