/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint.config;

import com.intellij.lang.javascript.linter.jshint.JSHintOptionsState;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintConfigLookupResult {
    private final VirtualFile myConfigFile;
    private final String myErrorMessage;
    private final JSHintOptionsState myOptionsState;

    public JSHintConfigLookupResult(@NotNull VirtualFile configFile, @Nullable String errorMessage, @Nullable JSHintOptionsState optionsState) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigLookupResult", "<init>"));
        }
        this.myConfigFile = configFile;
        this.myErrorMessage = errorMessage;
        this.myOptionsState = optionsState;
    }

    @NotNull
    public VirtualFile getConfigFile() {
        VirtualFile virtualFile = this.myConfigFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigLookupResult", "getConfigFile"));
        }
        return virtualFile;
    }

    @Nullable
    public String getErrorMessage() {
        return this.myErrorMessage;
    }

    @Nullable
    public JSHintOptionsState getOptionsState() {
        return this.myOptionsState;
    }

    @NotNull
    public static JSHintConfigLookupResult createSuccessfulResult(@NotNull VirtualFile configFile, @NotNull JSHintOptionsState optionsState) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigLookupResult", "createSuccessfulResult"));
        }
        if (optionsState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionsState", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigLookupResult", "createSuccessfulResult"));
        }
        JSHintConfigLookupResult jSHintConfigLookupResult = new JSHintConfigLookupResult(configFile, null, optionsState);
        if (jSHintConfigLookupResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigLookupResult", "createSuccessfulResult"));
        }
        return jSHintConfigLookupResult;
    }

    public static JSHintConfigLookupResult createErrorResult(@NotNull VirtualFile configFile, @NotNull String parseErrorMessage) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigLookupResult", "createErrorResult"));
        }
        if (parseErrorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parseErrorMessage", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigLookupResult", "createErrorResult"));
        }
        return new JSHintConfigLookupResult(configFile, parseErrorMessage, null);
    }
}

