/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint.config;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.jshint.JSHintDocumentation;
import com.intellij.lang.javascript.linter.jshint.JSHintOption;
import com.intellij.lang.javascript.linter.jshint.config.JSHintConfigFileType;
import com.intellij.lang.javascript.linter.jshint.config.JSHintConfigFileUtil;
import com.intellij.lang.javascript.linter.jshint.config.JSHintOptionCompletionObject;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.ui.HintHint;
import java.awt.Component;
import java.awt.Point;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintConfigDocumentationProvider
implements DocumentationProvider {
    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        return null;
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        return null;
    }

    @Nullable
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        String result = null;
        if (element != null) {
            result = this.doGenerateDoc(element);
        }
        if (result == null && originalElement != null) {
            result = this.doGenerateDoc(originalElement.getParent());
        }
        return result;
    }

    @Nullable
    public String doGenerateDoc(@NotNull PsiElement element) {
        String name;
        JSHintOption option;
        PsiElement keyElement;
        JsonProperty property;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigDocumentationProvider", "doGenerateDoc"));
        }
        if (JSHintConfigFileUtil.isJSHintConfigFile(element) && (property = JSLinterConfigFileUtil.getProperty(element)) != null && (keyElement = JSLinterConfigFileUtil.getFirstChildAsStringLiteral(property)) == element && (option = JSHintOption.findByName(name = StringUtil.stripQuotesAroundValue((String)element.getText()))) != null) {
            JSHintDocumentation documentation = JSHintDocumentation.getInstance();
            String html = documentation.getHtmlDescriptionByOption(option);
            if (html == null) {
                return null;
            }
            Component comp = null;
            HintHint hintHint = new HintHint(comp, new Point(0, 0));
            return HintUtil.prepareHintText((String)html, (HintHint)hintHint);
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (object instanceof JSHintOptionCompletionObject) {
            Project project;
            JSHintOptionCompletionObject option = (JSHintOptionCompletionObject)object;
            Project project2 = project = psiManager != null ? psiManager.getProject() : null;
            if (project != null) {
                return JSHintConfigDocumentationProvider.generateElement(project, option.getName());
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement generateElement(@NotNull Project project, @NotNull String key) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigDocumentationProvider", "generateElement"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigDocumentationProvider", "generateElement"));
        }
        String jsonText = "{" + StringUtil.wrapWithDoubleQuote((String)key) + ":\"\"}";
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText(".jshintrc", (FileType)JSHintConfigFileType.INSTANCE, (CharSequence)jsonText);
        PsiElement[] topLevelChildren = psiFile.getChildren();
        JsonObject objectLiteralExpression = null;
        for (PsiElement child : topLevelChildren) {
            if (!(child instanceof JsonObject)) continue;
            objectLiteralExpression = (JsonObject)child;
            break;
        }
        if (objectLiteralExpression == null) {
            return null;
        }
        List properties = objectLiteralExpression.getPropertyList();
        for (JsonProperty property : properties) {
            String name;
            PsiElement psiElement = JSLinterConfigFileUtil.getFirstChildAsStringLiteral(property);
            if (psiElement == null || !key.equals(name = StringUtil.stripQuotesAroundValue((String)psiElement.getText()))) continue;
            return psiElement;
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return null;
    }
}

