/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.intellij.lang.javascript.linter.option.OptionEnumType;
import com.intellij.lang.javascript.linter.option.OptionEnumVariant;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.DefaultCaret;
import javax.swing.text.html.HTMLEditorKit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintUtil {
    public static final OptionEnumType QUOTMARK_TYPE = new OptionEnumType(Arrays.asList(new OptionEnumVariant(false, "Both quotes allowed"), new OptionEnumVariant(true, "Only single or only double quotes allowed"), new OptionEnumVariant("single", "Only single quotes allowed"), new OptionEnumVariant("double", "Only double quotes allowed")));
    public static final OptionEnumType UNUSED_TYPE = new OptionEnumType(Arrays.asList(new OptionEnumVariant(false, "Don't check anything"), new OptionEnumVariant(true, "<html><body>Check all variables and parameters, but allow <br>unused parameters after a used parameter</body></html>"), new OptionEnumVariant("vars", "Check for variables, not function parameters"), new OptionEnumVariant("strict", "Check all variables and parameters")));
    public static final OptionEnumType LATEDEF_TYPE = new OptionEnumType(Arrays.asList(new OptionEnumVariant(false, "Don't warn"), new OptionEnumVariant(true, "Prohibit the use of a variable before it was defined"), new OptionEnumVariant("nofunc", "<html><body>Prohibit the use of a variable before it was defined, <br>but allow function declarations.</body></html>")));

    private JSHintUtil() {
    }

    @Nullable
    public static <T> T cast(@Nullable Object obj, @NotNull Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/linter/jshint/JSHintUtil", "cast"));
        }
        if (obj == null) {
            return null;
        }
        if (clazz.isInstance(obj)) {
            return clazz.cast(obj);
        }
        throw new ClassCastException("Expected type: " + clazz.getName() + ", actual: " + obj.getClass().getName());
    }

    @Nullable
    public static Integer castToInteger(@Nullable Object obj) {
        return JSHintUtil.cast(obj, Integer.class);
    }

    @Nullable
    public static String castToString(@Nullable Object obj) {
        return JSHintUtil.cast(obj, String.class);
    }

    public static JEditorPane createReadonlyBrowser(@NotNull String type, @NotNull String text) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/linter/jshint/JSHintUtil", "createReadonlyBrowser"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/linter/jshint/JSHintUtil", "createReadonlyBrowser"));
        }
        final JEditorPane browser = new JEditorPane(type, text);
        browser.setEditable(false);
        browser.setCaret(new NonAdjustableCaret());
        browser.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (keyCode == 40) {
                    JSHintUtil.handleArrow(browser, true, true);
                } else if (keyCode == 38) {
                    JSHintUtil.handleArrow(browser, true, false);
                } else if (keyCode == 37) {
                    JSHintUtil.handleArrow(browser, false, false);
                } else if (keyCode == 39) {
                    JSHintUtil.handleArrow(browser, false, true);
                }
            }
        });
        return browser;
    }

    private static void handleArrow(@NotNull JEditorPane browser, boolean vertical, boolean downRight) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/intellij/lang/javascript/linter/jshint/JSHintUtil", "handleArrow"));
        }
        Rectangle visibleRect = browser.getVisibleRect();
        int direction = downRight ? 1 : -1;
        int unit = browser.getScrollableUnitIncrement(visibleRect, vertical ? 1 : 0, direction);
        Rectangle newVisibleRect = new Rectangle(visibleRect);
        if (vertical) {
            newVisibleRect.y += unit * direction;
        } else {
            newVisibleRect.x += unit * direction;
        }
        browser.scrollRectToVisible(newVisibleRect);
    }

    @NotNull
    public static JComponent createIOExceptionBalloonComponent(@NotNull String text, final @NotNull Runnable retryCallback, boolean addConfigureHttpProxyLink) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/linter/jshint/JSHintUtil", "createIOExceptionBalloonComponent"));
        }
        if (retryCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "retryCallback", "com/intellij/lang/javascript/linter/jshint/JSHintUtil", "createIOExceptionBalloonComponent"));
        }
        JTextPane messageComponent = new JTextPane();
        messageComponent.setFont(UIUtil.getLabelFont());
        HTMLEditorKit editorKit = new HTMLEditorKit();
        editorKit.getStyleSheet().addRule(UIUtil.displayPropertiesToCSS((Font)UIUtil.getLabelFont(), (Color)UIUtil.getLabelForeground()));
        messageComponent.setEditorKit(editorKit);
        messageComponent.setContentType("text/html");
        String retry = "retry";
        String proxy = "proxy";
        messageComponent.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            public void hyperlinkActivated(HyperlinkEvent e) {
                if ("retry".equals(e.getDescription())) {
                    retryCallback.run();
                } else if ("proxy".equals(e.getDescription())) {
                    HttpConfigurable.editConfigurable(null);
                }
            }
        });
        StringBuilder html = new StringBuilder("<html><body>").append(text).append("<br/>");
        if (addConfigureHttpProxyLink) {
            html.append(JSHintUtil.hyperlink("proxy", "Configure HTTP proxy")).append(" or ");
        }
        html.append(JSHintUtil.hyperlink("retry", "Retry"));
        html.append("</body></html>");
        messageComponent.setText(html.toString());
        messageComponent.setEditable(false);
        if (messageComponent.getCaret() != null) {
            messageComponent.setCaretPosition(0);
        }
        messageComponent.setOpaque(false);
        messageComponent.setBackground(UIUtil.TRANSPARENT_COLOR);
        messageComponent.setForeground(UIUtil.getLabelForeground());
        JTextPane jTextPane = messageComponent;
        if (jTextPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintUtil", "createIOExceptionBalloonComponent"));
        }
        return jTextPane;
    }

    private static String hyperlink(@NotNull String href, @NotNull String description) {
        if (href == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "href", "com/intellij/lang/javascript/linter/jshint/JSHintUtil", "hyperlink"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/lang/javascript/linter/jshint/JSHintUtil", "hyperlink"));
        }
        return "<a href=\"" + href + "\">" + description + "</a>";
    }

    private static class NonAdjustableCaret
    extends DefaultCaret {
        private NonAdjustableCaret() {
        }

        @Override
        protected void adjustVisibility(Rectangle newLocation) {
        }
    }
}

