/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.intellij.lang.javascript.linter.jshint.JSHintOption;
import com.intellij.lang.javascript.linter.jshint.JSHintOptionGroup;
import com.intellij.lang.javascript.linter.option.OptionTypes;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ObjectUtils;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintTreeNode
extends CheckedTreeNode {
    private final Tree myTree;
    private final String myDescription;
    private final String myTitle;
    private Object myValue;
    private boolean myMouseInside;

    public JSHintTreeNode(@NotNull Tree tree, @NotNull JSHintOptionGroup optionGroup) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/lang/javascript/linter/jshint/JSHintTreeNode", "<init>"));
        }
        if (optionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionGroup", "com/intellij/lang/javascript/linter/jshint/JSHintTreeNode", "<init>"));
        }
        super((Object)optionGroup);
        this.myMouseInside = false;
        this.myTree = tree;
        this.myDescription = optionGroup.getDescription();
        this.myTitle = optionGroup.getTitle();
    }

    public JSHintTreeNode(@NotNull Tree tree, @NotNull JSHintOption option, @NotNull String description) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/lang/javascript/linter/jshint/JSHintTreeNode", "<init>"));
        }
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/linter/jshint/JSHintTreeNode", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/lang/javascript/linter/jshint/JSHintTreeNode", "<init>"));
        }
        super((Object)option);
        this.myMouseInside = false;
        this.myTree = tree;
        this.myDescription = description;
        this.myTitle = option.getShortDescription();
        if (OptionTypes.isEnumOption(option)) {
            this.myValue = option.getDefaultValue();
        }
    }

    public String getTitle() {
        return this.myTitle;
    }

    @Nullable
    public Object getValue() {
        return this.myValue;
    }

    public void setValue(@Nullable Object value) {
        JSHintOption option = this.getUserDataAsOption();
        if (value == null && option != null) {
            value = option.getDefaultValue();
        }
        this.myValue = value;
        this.myTree.getModel().valueForPathChanged(new TreePath(this.getPath()), this.getUserObject());
    }

    public void setMouseInside(boolean mouseInside) {
        boolean changed = this.myMouseInside != mouseInside;
        this.myMouseInside = mouseInside;
        if (changed) {
            this.myTree.repaint();
        }
    }

    public boolean isMouseInside() {
        return this.myMouseInside;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintTreeNode", "getDescription"));
        }
        return string;
    }

    public boolean isOption() {
        return this.getUserObject() instanceof JSHintOption;
    }

    @Nullable
    public JSHintOption getUserDataAsOption() {
        return (JSHintOption)ObjectUtils.tryCast((Object)this.getUserObject(), JSHintOption.class);
    }

    @Nullable
    public JSHintOptionGroup getUserDataAsOptionGroup() {
        return (JSHintOptionGroup)ObjectUtils.tryCast((Object)this.getUserObject(), JSHintOptionGroup.class);
    }

    public boolean isEditLinkNeeded() {
        JSHintOption option = this.getUserDataAsOption();
        if (option == null) {
            return false;
        }
        return !OptionTypes.isBooleanOption(option);
    }

    public String toString() {
        JSHintOption option = this.getUserDataAsOption();
        if (option != null) {
            return "option " + option.getKey();
        }
        JSHintOptionGroup optionGroup = this.getUserDataAsOptionGroup();
        if (optionGroup != null) {
            return "optionGroup " + optionGroup.getTitle();
        }
        return "internal error";
    }
}

