/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.google.common.collect.ImmutableMap;
import com.intellij.lang.javascript.linter.jshint.JSHintOption;
import com.intellij.lang.javascript.linter.jshint.JSHintUtil;
import com.intellij.lang.javascript.linter.option.OptionEnumType;
import com.intellij.lang.javascript.linter.option.OptionEnumVariant;
import com.intellij.lang.javascript.linter.option.OptionTypes;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintOptionsState {
    private final Map<String, Object> myValueByOptionMap;

    private JSHintOptionsState(@NotNull Map<String, Object> valueByOptionMap) {
        if (valueByOptionMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueByOptionMap", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsState", "<init>"));
        }
        this.myValueByOptionMap = ImmutableMap.copyOf(valueByOptionMap);
    }

    @NotNull
    public Set<String> getOptionKeys() {
        Set<String> set = this.myValueByOptionMap.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsState", "getOptionKeys"));
        }
        return set;
    }

    @NotNull
    public Map<String, Object> getValueByOptionMap() {
        Map<String, Object> map = this.myValueByOptionMap;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsState", "getValueByOptionMap"));
        }
        return map;
    }

    @Nullable
    public Object getValue(@NotNull String optionKey) {
        JSHintOption option;
        if (optionKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionKey", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsState", "getValue"));
        }
        Object value = this.myValueByOptionMap.get(optionKey);
        if (value == null && (option = JSHintOption.findByName(optionKey)) != null) {
            return option.getDefaultValue();
        }
        return value;
    }

    @Nullable
    public Object getValue(@NotNull JSHintOption option) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsState", "getValue"));
        }
        return this.getValue(option.getKey());
    }

    @NotNull
    public OptionEnumVariant getEnumVariant(@NotNull JSHintOption option) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsState", "getEnumVariant"));
        }
        Object value = this.getValue(option);
        OptionEnumVariant optionEnumVariant = OptionEnumType.findVariantByValueOrFail(option, value);
        if (optionEnumVariant == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsState", "getEnumVariant"));
        }
        return optionEnumVariant;
    }

    public boolean getBoolean(@NotNull JSHintOption option) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsState", "getBoolean"));
        }
        if (!OptionTypes.isBooleanOption(option)) {
            throw new RuntimeException("Option " + option + " has " + option.getType() + " type, but boolean type was expected.");
        }
        Object obj = this.getValue(option);
        if (obj == null) {
            throw new RuntimeException("Boolean type shouldn't be null");
        }
        return (Boolean)obj;
    }

    @Nullable
    public String getString(@NotNull JSHintOption option) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsState", "getString"));
        }
        if (!OptionTypes.isStringOption(option)) {
            throw new RuntimeException("Option " + option + " has " + option.getType() + " type, but string type was expected.");
        }
        Object obj = this.myValueByOptionMap.get(option.getKey());
        return JSHintUtil.castToString(obj);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSHintOptionsState that = (JSHintOptionsState)o;
        for (JSHintOption option : JSHintOption.values()) {
            Object thatValue;
            Object thisValue = this.getValue(option);
            if (ComparatorUtil.equalsNullable((Object)thisValue, (Object)(thatValue = that.getValue(option)))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.myValueByOptionMap.hashCode();
    }

    public String toString() {
        return this.myValueByOptionMap.toString();
    }

    public static class Builder {
        private final Map<String, Object> myValueByOptionMap = new HashMap();

        public Builder put(@NotNull JSHintOption option, @Nullable Object value) {
            if (option == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsState$Builder", "put"));
            }
            this.put(option.getKey(), value);
            return this;
        }

        public Builder put(@NotNull String key, @Nullable Object value) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsState$Builder", "put"));
            }
            String newKey = key;
            JSHintOption option = JSHintOption.findByName(key);
            if (option != null) {
                newKey = option.getKey();
            }
            if (value == null) {
                this.myValueByOptionMap.remove(newKey);
            } else {
                this.myValueByOptionMap.put(newKey, value);
            }
            return this;
        }

        @NotNull
        public JSHintOptionsState build() {
            JSHintOptionsState jSHintOptionsState = new JSHintOptionsState(this.myValueByOptionMap);
            if (jSHintOptionsState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsState$Builder", "build"));
            }
            return jSHintOptionsState;
        }
    }
}

