/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class JSHintIgnoreInfo {
    private static final char SEPARATOR_CHAR = '/';
    private static final Pattern[] TRUNCATING_PATTERNS = new Pattern[]{Pattern.compile("/[^/]*\\{.*\\}.*$"), Pattern.compile("/[^/]*!\\(.*$"), Pattern.compile("/[^/]*\\+\\(.*$"), Pattern.compile("/[^/]*\\)\\?.*$")};
    private final List<VirtualFile> myIgnoreRoots;
    private final List<Pattern> myIgnorePatterns;
    private VirtualFile myIgnoreDir;

    public JSHintIgnoreInfo(@NotNull VirtualFile jshintIgnore, @NotNull List<String> patterns) {
        if (jshintIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jshintIgnore", "com/intellij/lang/javascript/linter/jshint/JSHintIgnoreInfo", "<init>"));
        }
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "com/intellij/lang/javascript/linter/jshint/JSHintIgnoreInfo", "<init>"));
        }
        this.myIgnoreRoots = ContainerUtil.newArrayList();
        this.myIgnorePatterns = ContainerUtil.newArrayList();
        this.myIgnoreDir = jshintIgnore.getParent();
        if (this.myIgnoreDir != null && this.myIgnoreDir.isDirectory()) {
            for (String pattern : patterns) {
                String refinedPattern = pattern.replace('\\', '/');
                VirtualFile file = this.myIgnoreDir.findFileByRelativePath(refinedPattern = JSHintIgnoreInfo.findPrefix(refinedPattern));
                if (file != null && file.isValid()) {
                    this.myIgnoreRoots.add(file);
                    continue;
                }
                Pattern p = JSHintIgnoreInfo.buildPattern(refinedPattern);
                this.myIgnorePatterns.add(p);
            }
        }
    }

    @NotNull
    private static Pattern buildPattern(@NotNull String pattern) {
        int singleInd;
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/lang/javascript/linter/jshint/JSHintIgnoreInfo", "buildPattern"));
        }
        int i = 0;
        StringBuilder res = new StringBuilder("^");
        while (i < pattern.length() && (singleInd = pattern.indexOf("*", i)) != -1) {
            JSHintIgnoreInfo.addQuotePattern(res, pattern, i, singleInd);
            if (singleInd + 2 == pattern.length() && pattern.startsWith("**", singleInd)) {
                res.append(".*");
                i = singleInd + 2;
                continue;
            }
            if (pattern.startsWith("**/", singleInd)) {
                res.append(".*");
                i = singleInd + 3;
                continue;
            }
            res.append("[^/]*");
            i = singleInd + 1;
        }
        JSHintIgnoreInfo.addQuotePattern(res, pattern, i, pattern.length());
        res.append("$");
        Pattern pattern2 = Pattern.compile(res.toString());
        if (pattern2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintIgnoreInfo", "buildPattern"));
        }
        return pattern2;
    }

    private static void addQuotePattern(@NotNull StringBuilder buf, @NotNull String pattern, int fromInc, int toExc) {
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "com/intellij/lang/javascript/linter/jshint/JSHintIgnoreInfo", "addQuotePattern"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/lang/javascript/linter/jshint/JSHintIgnoreInfo", "addQuotePattern"));
        }
        if (fromInc < toExc) {
            buf.append(Pattern.quote(pattern.substring(fromInc, toExc)));
        }
    }

    @NotNull
    public static String findPrefix(@NotNull String refinedPattern) {
        if (refinedPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refinedPattern", "com/intellij/lang/javascript/linter/jshint/JSHintIgnoreInfo", "findPrefix"));
        }
        for (Pattern pattern : TRUNCATING_PATTERNS) {
            refinedPattern = pattern.matcher(refinedPattern).replaceFirst("");
        }
        String string = refinedPattern;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintIgnoreInfo", "findPrefix"));
        }
        return string;
    }

    public boolean isIgnore(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/jshint/JSHintIgnoreInfo", "isIgnore"));
        }
        for (VirtualFile root : this.myIgnoreRoots) {
            if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        if (this.myIgnoreDir != null && !this.myIgnorePatterns.isEmpty() && VfsUtilCore.isAncestor((VirtualFile)this.myIgnoreDir, (VirtualFile)file, (boolean)true)) {
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)this.myIgnoreDir, (char)'/');
            if (relativePath == null) {
                return false;
            }
            for (Pattern pattern : this.myIgnorePatterns) {
                Matcher matcher = pattern.matcher(relativePath);
                if (!matcher.matches()) continue;
                return true;
            }
        }
        return false;
    }
}

