/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs;

import com.intellij.ide.BrowserUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.linter.JSLinterBaseView;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.NodeModuleConfigurationView;
import com.intellij.lang.javascript.linter.jscs.JscsPreset;
import com.intellij.lang.javascript.linter.jscs.JscsState;
import com.intellij.lang.javascript.linter.jscs.config.JscsConfigFileType;
import com.intellij.lang.javascript.linter.ui.JSLinterConfigFileTexts;
import com.intellij.lang.javascript.linter.ui.JSLinterConfigFileView;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JscsView
extends JSLinterBaseView<JscsState> {
    private static final JSLinterConfigFileTexts CONFIG_TEXTS = JscsView.getConfigTexts();
    private final JSLinterConfigFileView myConfigFileView;
    private final NodeModuleConfigurationView myNodeModuleConfigurationView;
    private final ComponentWithBrowseButton<ComboBox> myPresetWithHelp;
    private JPanel myPresetHint;

    public JscsView(@NotNull Project project, boolean isFullModeDialog) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jscs/JscsView", "<init>"));
        }
        super(isFullModeDialog);
        this.myConfigFileView = new JSLinterConfigFileView(project, CONFIG_TEXTS, (FileType)JscsConfigFileType.INSTANCE);
        this.myNodeModuleConfigurationView = new NodeModuleConfigurationView(project, "jscs", "JSCS", null);
        this.myPresetWithHelp = JscsView.createPresetWithHelpButton();
        JEditorPane presetHintComp = JSLinterUtil.createHtmlViewer(JSBundle.message((String)"jscs.configurable.preset.hint.text", (Object[])new Object[0]), UIUtil.getTitledBorderFont());
        this.myPresetHint = SwingHelper.wrapWithHorizontalStretch((JComponent)presetHintComp);
    }

    @Override
    @Nullable
    protected Component createTopRightComponent() {
        return null;
    }

    @Override
    @NotNull
    protected Component createCenterComponent() {
        JPanel panel = FormBuilder.createFormBuilder().setAlignLabelOnRight(true).setHorizontalGap(10).setVerticalGap(4).setFormLeftIndent(10).addLabeledComponent("&Node interpreter:", this.myNodeModuleConfigurationView.getNodeInterpreterField().getComponent()).addLabeledComponent(JSBundle.message((String)"jscs.configurable.label.package.path", (Object[])new Object[0]), (JComponent)this.myNodeModuleConfigurationView.getPackageField()).addComponent((JComponent)this.myConfigFileView.getComponent()).addLabeledComponent(JSBundle.message((String)"jscs.configurable.label.preset.label.text", (Object[])new Object[0]), this.myPresetWithHelp).addLabeledComponent("", (JComponent)this.myPresetHint).getPanel();
        JPanel centerPanel = SwingHelper.wrapWithHorizontalStretch((JComponent)panel);
        centerPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        JPanel jPanel = centerPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/JscsView", "createCenterComponent"));
        }
        return jPanel;
    }

    public static ComponentWithBrowseButton<ComboBox> createPresetWithHelpButton() {
        final ComboBox box = new ComboBox();
        ComponentWithBrowseButton comp = new ComponentWithBrowseButton((JComponent)box, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object item = box.getSelectedItem();
                String url = item instanceof JscsPreset ? ((JscsPreset)((Object)item)).getDescribeUrl() : "https://www.npmjs.org/package/jscs#presets";
                BrowserUtil.browse((String)url);
            }
        });
        FixedSizeButton uiHelpButton = comp.getButton();
        uiHelpButton.setToolTipText(JSBundle.message((String)"jscs.configurable.preset.show.in.browser.tooltip", (Object[])new Object[0]));
        uiHelpButton.setIcon(UIUtil.getBalloonInformationIcon());
        uiHelpButton.setHorizontalAlignment(0);
        uiHelpButton.setVerticalAlignment(0);
        JscsView.fillPresets(box);
        return comp;
    }

    @Override
    protected void handleEnableStatusChanged(boolean enabled) {
        this.enableCustomConfigPath(enabled);
    }

    @Override
    @NotNull
    protected JscsState getState() {
        JscsState.Builder builder = new JscsState.Builder().setNodePath(this.myNodeModuleConfigurationView.getNodeInterpreterField().get()).setPackagePath(this.myNodeModuleConfigurationView.getPackageField().getText().trim()).setCustomConfigFileUsed(this.myConfigFileView.isCustomConfigFileUsed()).setCustomConfigFilePath(this.myConfigFileView.getCustomConfigFilePath());
        JscsPreset item = (JscsPreset)((Object)((ComboBox)this.myPresetWithHelp.getChildComponent()).getSelectedItem());
        if (item != null) {
            builder.setPreset(item);
        }
        JscsState jscsState = builder.build();
        if (jscsState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/JscsView", "getState"));
        }
        return jscsState;
    }

    @Override
    protected void setState(@NotNull JscsState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/jscs/JscsView", "setState"));
        }
        this.myNodeModuleConfigurationView.getNodeInterpreterField().set(StringUtil.notNullize((String)state.getNodePath()));
        ((TextFieldWithHistory)this.myNodeModuleConfigurationView.getPackageField().getChildComponent()).setText(StringUtil.notNullize((String)state.getPackagePath()));
        this.myConfigFileView.setCustomConfigFileUsed(state.isCustomConfigFileUsed());
        this.myConfigFileView.setCustomConfigFilePath(state.getCustomConfigFilePath());
        JscsPreset preset = state.getPreset();
        if (preset != null) {
            ((ComboBox)this.myPresetWithHelp.getChildComponent()).setSelectedItem((Object)preset);
        } else {
            ((ComboBox)this.myPresetWithHelp.getChildComponent()).setSelectedIndex(0);
        }
        this.resizeOnSeparateDialog();
    }

    private void resizeOnSeparateDialog() {
        if (this.isFullModeDialog()) {
            this.myNodeModuleConfigurationView.setPreferredWidthToComponents();
            this.myConfigFileView.setPreferredWidthToComponents();
        }
    }

    private void enableCustomConfigPath(boolean enabled) {
        this.myConfigFileView.onEnabledStateChanged(enabled);
        this.myPresetHint.setForeground(UIUtil.getLabelDisabledForeground());
    }

    private static JSLinterConfigFileTexts getConfigTexts() {
        return new JSLinterConfigFileTexts(JSBundle.message((String)"jscs.configurable.look.for.config.files", (Object[])new Object[0]), JSBundle.message((String)"jscs.configurable.label.default.config.description", (Object[])new Object[0]), JSBundle.message((String)"jscs.configurable.select.config.file.text", (Object[])new Object[0]));
    }

    private static void fillPresets(ComboBox comboBox) {
        ArrayList<Object> items = new ArrayList<Object>(JscsPreset.values().length + 1);
        Collections.addAll(items, JscsPreset.values());
        Collections.sort(items);
        items.add(0, null);
        comboBox.setModel((ComboBoxModel)new CollectionComboBoxModel(items));
        comboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<JscsPreset>(){

            public void customize(JList list, JscsPreset value, int index, boolean selected, boolean hasFocus) {
                if (value == null) {
                    this.setText("");
                    return;
                }
                this.setText(value.getDisplayName());
            }
        });
    }
}

