/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs;

import com.intellij.lang.javascript.linter.JSLinterState;
import com.intellij.lang.javascript.linter.jscs.JscsPreset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JscsState
implements JSLinterState {
    private final boolean myCustomConfigFileUsed;
    private String myCustomConfigFilePath;
    private final String myNodePath;
    private final String myPackagePath;
    @Nullable
    private final JscsPreset myPreset;

    public JscsState(boolean customConfigFileUsed, String customConfigPath, String nodePath, String packagePath, @Nullable JscsPreset preset) {
        this.myCustomConfigFileUsed = customConfigFileUsed;
        this.myCustomConfigFilePath = customConfigPath;
        this.myNodePath = nodePath;
        this.myPackagePath = packagePath;
        this.myPreset = preset;
    }

    public void setCustomConfigFilePath(String customConfigFilePath) {
        this.myCustomConfigFilePath = customConfigFilePath;
    }

    public boolean isCustomConfigFileUsed() {
        return this.myCustomConfigFileUsed;
    }

    public String getCustomConfigFilePath() {
        return this.myCustomConfigFilePath;
    }

    public String getNodePath() {
        return this.myNodePath;
    }

    public String getPackagePath() {
        return this.myPackagePath;
    }

    @Nullable
    public JscsPreset getPreset() {
        return this.myPreset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JscsState state = (JscsState)o;
        if (this.myCustomConfigFileUsed != state.myCustomConfigFileUsed) {
            return false;
        }
        if (this.myCustomConfigFilePath != null ? !this.myCustomConfigFilePath.equals(state.myCustomConfigFilePath) : state.myCustomConfigFilePath != null) {
            return false;
        }
        if (this.myNodePath != null ? !this.myNodePath.equals(state.myNodePath) : state.myNodePath != null) {
            return false;
        }
        if (this.myPackagePath != null ? !this.myPackagePath.equals(state.myPackagePath) : state.myPackagePath != null) {
            return false;
        }
        return this.myPreset == state.myPreset;
    }

    public int hashCode() {
        int result = this.myCustomConfigFileUsed ? 1 : 0;
        result = 31 * result + (this.myCustomConfigFilePath != null ? this.myCustomConfigFilePath.hashCode() : 0);
        result = 31 * result + (this.myNodePath != null ? this.myNodePath.hashCode() : 0);
        result = 31 * result + (this.myPackagePath != null ? this.myPackagePath.hashCode() : 0);
        result = 31 * result + (this.myPreset != null ? this.myPreset.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "JscsState{myCustomConfigFileUsed=" + this.myCustomConfigFileUsed + ", myCustomConfigFilePath='" + this.myCustomConfigFilePath + '\'' + ", myNodePath='" + this.myNodePath + '\'' + ", myPackagePath='" + this.myPackagePath + '\'' + ", myPreset=" + (Object)((Object)this.myPreset) + '}';
    }

    public static class Builder {
        private boolean myCustomConfigFileUsed;
        private String myCustomConfigFilePath;
        private String myNodePath;
        private String myPackagePath;
        @Nullable
        private JscsPreset myPreset;

        public Builder() {
            this.myCustomConfigFileUsed = false;
            this.myCustomConfigFilePath = "";
            this.myNodePath = "";
            this.myPackagePath = "";
        }

        public Builder(@NotNull JscsState state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/jscs/JscsState$Builder", "<init>"));
            }
            this.myCustomConfigFileUsed = false;
            this.myCustomConfigFilePath = "";
            this.myNodePath = "";
            this.myPackagePath = "";
            this.myCustomConfigFilePath = state.getCustomConfigFilePath();
            this.myCustomConfigFileUsed = state.isCustomConfigFileUsed();
            this.myNodePath = state.getNodePath();
            this.myPackagePath = state.getPackagePath();
            this.myPreset = state.getPreset();
        }

        public Builder setCustomConfigFileUsed(boolean customConfigFileUsed) {
            this.myCustomConfigFileUsed = customConfigFileUsed;
            return this;
        }

        public Builder setCustomConfigFilePath(@NotNull String customConfigFilePath) {
            if (customConfigFilePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customConfigFilePath", "com/intellij/lang/javascript/linter/jscs/JscsState$Builder", "setCustomConfigFilePath"));
            }
            this.myCustomConfigFilePath = customConfigFilePath;
            return this;
        }

        public Builder setNodePath(String nodePath) {
            this.myNodePath = nodePath;
            return this;
        }

        public Builder setPackagePath(String packagePath) {
            this.myPackagePath = packagePath;
            return this;
        }

        public Builder setPreset(@Nullable JscsPreset preset) {
            this.myPreset = preset;
            return this;
        }

        public boolean isCustomConfigFileUsed() {
            return this.myCustomConfigFileUsed;
        }

        public String getCustomConfigFilePath() {
            return this.myCustomConfigFilePath;
        }

        public String getNodePath() {
            return this.myNodePath;
        }

        public String getPackagePath() {
            return this.myPackagePath;
        }

        @Nullable
        public JscsPreset getPreset() {
            return this.myPreset;
        }

        public JscsState build() {
            return new JscsState(this.myCustomConfigFileUsed, this.myCustomConfigFilePath, this.myNodePath, this.myPackagePath, this.myPreset);
        }
    }
}

