/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.NodeDetectionUtil;
import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.PathHolder;
import com.intellij.lang.javascript.linter.SharedConfigurationPaths;
import com.intellij.lang.javascript.linter.jscs.JscsInspection;
import com.intellij.lang.javascript.linter.jscs.JscsPreset;
import com.intellij.lang.javascript.linter.jscs.JscsState;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="JscsConfiguration", storages={@Storage(value="jsLinters/jscs.xml")})
public class JscsConfiguration
extends JSLinterConfiguration<JscsState> {
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"JSCS Messages");
    public static final NotificationGroup IMPORT_CONFIG_NOTIFICATION = NotificationGroup.logOnlyGroup((String)"JSCS Config Import");
    public static final String LOG_CATEGORY = "#com.intellij.lang.javascript.linter.jscs.Jscs";
    private static final String JSCS_ELEMENT_NAME = "jscs";
    private static final String IS_CUSTOM_CONFIG_FILE_USED_ATTRIBUTE_NAME = "use-custom-config-file";
    private static final String CUSTOM_CONFIG_FILE_PATH_ATTRIBUTE_NAME = "custom-config-file-path";
    private static final String PRESET = "jscs-preset";
    private static final String NODE_INTERPRETER_PATH = "js-jscs-nodeInterpreter";
    private static final String JSCS_PACKAGE_PATH = "js-jscs-package";
    private final PathHolder myPathHolder;
    private JscsState DEFAULT_STATE;

    public JscsConfiguration(@NotNull Project project, @NotNull SharedConfigurationPaths paths) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jscs/JscsConfiguration", "<init>"));
        }
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/intellij/lang/javascript/linter/jscs/JscsConfiguration", "<init>"));
        }
        super(project);
        this.myPathHolder = paths.createPathHolder(new Runnable(){

            @Override
            public void run() {
                ExtendedLinterState state = JscsConfiguration.this.getExtendedState();
                ((JscsState)state.getState()).setCustomConfigFilePath(JscsConfiguration.this.myPathHolder.getPath());
                JscsConfiguration.this.setExtendedState(state);
            }
        });
    }

    @Override
    protected void savePrivateSettings(@NotNull JscsState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/jscs/JscsConfiguration", "savePrivateSettings"));
        }
        this.myPathHolder.setPath(state.getCustomConfigFilePath());
        this.storeLinterLocalPaths(state);
    }

    @Override
    @NotNull
    public JscsState loadPrivateSettings(@NotNull JscsState state) {
        Object nodePath;
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/jscs/JscsConfiguration", "loadPrivateSettings"));
        }
        this.myPathHolder.setPath(state.getCustomConfigFilePath());
        JscsState.Builder builder = new JscsState.Builder(state);
        this.restoreLinterLocalPaths(builder);
        if (StringUtil.isEmptyOrSpaces((String)builder.getNodePath()) && (nodePath = NodeDetectionUtil.findInterpreterInPath()) != null && ((File)nodePath).isFile() && ((File)nodePath).isAbsolute()) {
            builder.setNodePath(((File)nodePath).getAbsolutePath());
        }
        if (StringUtil.isEmptyOrSpaces((String)builder.getPackagePath())) {
            nodePath = builder.getNodePath();
            String packagePath = JSLinterUtil.findPackageForNodePath(this.getProject(), (String)(nodePath != null ? nodePath : null), JSCS_ELEMENT_NAME);
            if (packagePath != null) {
                builder.setPackagePath(FileUtil.toSystemDependentName((String)packagePath));
            }
        }
        JscsState jscsState = builder.build();
        if (jscsState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/JscsConfiguration", "loadPrivateSettings"));
        }
        return jscsState;
    }

    @NotNull
    public static JscsConfiguration getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jscs/JscsConfiguration", "getInstance"));
        }
        JscsConfiguration jscsConfiguration = JSLinterConfiguration.getInstance(project, JscsConfiguration.class);
        if (jscsConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/JscsConfiguration", "getInstance"));
        }
        return jscsConfiguration;
    }

    @Override
    @NotNull
    protected Class<? extends JSLinterInspection> getInspectionClass() {
        if (JscsInspection.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/JscsConfiguration", "getInspectionClass"));
        }
        return JscsInspection.class;
    }

    @Override
    @NotNull
    protected Element toXml(@NotNull JscsState state) {
        JscsPreset preset;
        String customConfigFilePath;
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/jscs/JscsConfiguration", "toXml"));
        }
        Element root = new Element(JSCS_ELEMENT_NAME);
        if (state.isCustomConfigFileUsed()) {
            root.setAttribute(IS_CUSTOM_CONFIG_FILE_USED_ATTRIBUTE_NAME, Boolean.TRUE.toString());
        }
        if (!StringUtil.isEmptyOrSpaces((String)(customConfigFilePath = state.getCustomConfigFilePath()))) {
            root.setAttribute(CUSTOM_CONFIG_FILE_PATH_ATTRIBUTE_NAME, FileUtil.toSystemIndependentName((String)customConfigFilePath));
        }
        if ((preset = state.getPreset()) != null) {
            root.setAttribute(PRESET, preset.name());
        }
        this.storeLinterLocalPaths(state);
        Element element = root;
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/JscsConfiguration", "toXml"));
        }
        return element;
    }

    @Override
    @NotNull
    protected JscsState fromXml(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/jscs/JscsConfiguration", "fromXml"));
        }
        JscsState.Builder builder = new JscsState.Builder();
        builder.setCustomConfigFileUsed(Boolean.parseBoolean(element.getAttributeValue(IS_CUSTOM_CONFIG_FILE_USED_ATTRIBUTE_NAME)));
        String customConfigFilePath = StringUtil.notNullize((String)element.getAttributeValue(CUSTOM_CONFIG_FILE_PATH_ATTRIBUTE_NAME));
        builder.setCustomConfigFilePath(FileUtil.toSystemDependentName((String)customConfigFilePath));
        String presetName = element.getAttributeValue(PRESET);
        if (!StringUtil.isEmptyOrSpaces((String)presetName)) {
            builder.setPreset(JscsPreset.safeValueOf(presetName));
        }
        this.restoreLinterLocalPaths(builder);
        JscsState jscsState = builder.build();
        if (jscsState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/JscsConfiguration", "fromXml"));
        }
        return jscsState;
    }

    private void storeLinterLocalPaths(@NotNull JscsState state) {
        String packagePath;
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/jscs/JscsConfiguration", "storeLinterLocalPaths"));
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.getProject());
        String nodePath = state.getNodePath();
        if (!StringUtil.isEmptyOrSpaces((String)nodePath)) {
            propertiesComponent.setValue(NODE_INTERPRETER_PATH, nodePath);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(packagePath = state.getPackagePath()))) {
            propertiesComponent.setValue(JSCS_PACKAGE_PATH, packagePath);
        }
    }

    private void restoreLinterLocalPaths(JscsState.Builder builder) {
        PropertiesComponent applicationComponent = PropertiesComponent.getInstance();
        String node = applicationComponent.getValue(NODE_INTERPRETER_PATH);
        String jscs = applicationComponent.getValue(JSCS_PACKAGE_PATH);
        if (node != null || jscs != null) {
            applicationComponent.unsetValue(NODE_INTERPRETER_PATH);
            applicationComponent.unsetValue(JSCS_PACKAGE_PATH);
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.getProject());
        String nodePrj = propertiesComponent.getValue(NODE_INTERPRETER_PATH);
        String jscsPrj = propertiesComponent.getValue(JSCS_PACKAGE_PATH);
        node = nodePrj != null ? nodePrj : node;
        String string = jscs = jscsPrj != null ? jscsPrj : jscs;
        if (!StringUtil.isEmptyOrSpaces((String)node) || !StringUtil.isEmptyOrSpaces((String)jscs)) {
            builder.setNodePath(StringUtil.notNullize((String)node));
            builder.setPackagePath(StringUtil.notNullize((String)jscs));
        }
    }

    @Override
    @NotNull
    protected JscsState getDefaultState() {
        JscsState state = this.DEFAULT_STATE;
        if (state != null) {
            JscsState jscsState = state;
            if (jscsState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/JscsConfiguration", "getDefaultState"));
            }
            return jscsState;
        }
        JscsState.Builder builder = new JscsState.Builder();
        builder.setCustomConfigFileUsed(false);
        this.DEFAULT_STATE = state = builder.build();
        JscsState jscsState = state;
        if (jscsState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/JscsConfiguration", "getDefaultState"));
        }
        return jscsState;
    }
}

