/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs;

import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.javascript.linter.JSLinterEditConfigFileAction;
import com.intellij.lang.javascript.linter.jscs.config.JscsConfigFileAnnotator;
import com.intellij.lang.javascript.linter.jscs.config.ValueType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class EditFirstTypeErrorInConfig
extends JSLinterEditConfigFileAction {
    public EditFirstTypeErrorInConfig(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/javascript/linter/jscs/EditFirstTypeErrorInConfig", "<init>"));
        }
        super(virtualFile, null);
    }

    @Override
    public void invokeReally(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jscs/EditFirstTypeErrorInConfig", "invokeReally"));
        }
        this.preparation(project, file);
        super.invokeReally(project, editor, file);
    }

    private void preparation(Project project, PsiFile file) {
        PsiFile psiFile;
        Document document = FileDocumentManager.getInstance().getDocument(this.myVirtualFile);
        if (document != null && (psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document)) != null) {
            AnnotationHolderImpl holder = new AnnotationHolderImpl(new AnnotationSession(psiFile));
            JscsConfigFileAnnotator annotator = new JscsConfigFileAnnotator();
            annotator.annotate((PsiElement)psiFile, (AnnotationHolder)holder);
            ArrayList<Integer> offsets = new ArrayList<Integer>();
            for (int i = 0; i < holder.size(); ++i) {
                String message;
                Annotation annotation = (Annotation)holder.get(i);
                if (annotation.getMessage() == null || !(message = annotation.getMessage()).contains("Expected") || !EditFirstTypeErrorInConfig.containsTypeName(message)) continue;
                offsets.add(annotation.getStartOffset());
            }
            for (Integer offset : offsets) {
                JsonProperty property = (JsonProperty)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiFile, (int)offset, JsonProperty.class, (boolean)false);
                if (property == null) continue;
                this.setProperty(property.getName());
                return;
            }
        }
    }

    private static boolean containsTypeName(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/lang/javascript/linter/jscs/EditFirstTypeErrorInConfig", "containsTypeName"));
        }
        for (ValueType type : ValueType.values()) {
            if (!s.contains(type.getNameOrFixedValue())) continue;
            return true;
        }
        return false;
    }
}

