/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterAnnotationsBuilder;
import com.intellij.lang.javascript.linter.JSLinterConfigurable;
import com.intellij.lang.javascript.linter.JSLinterErrorBase;
import com.intellij.lang.javascript.linter.JSLinterExternalAnnotator;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.eslint.EsLintExternalRunner;
import com.intellij.lang.javascript.linter.eslint.EsLintReformatterTask;
import com.intellij.lang.javascript.linter.eslint.EslintConfigurable;
import com.intellij.lang.javascript.linter.eslint.EslintConfiguration;
import com.intellij.lang.javascript.linter.eslint.EslintInspection;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import icons.JavaScriptLanguageIcons;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EslintExternalAnnotator
extends JSLinterExternalAnnotator<EslintState> {
    private static final EslintExternalAnnotator INSTANCE_FOR_BATCH_INSPECTION = new EslintExternalAnnotator(false);

    @NotNull
    public static EslintExternalAnnotator getInstanceForBatchInspection() {
        EslintExternalAnnotator eslintExternalAnnotator = INSTANCE_FOR_BATCH_INSPECTION;
        if (eslintExternalAnnotator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "getInstanceForBatchInspection"));
        }
        return eslintExternalAnnotator;
    }

    public EslintExternalAnnotator() {
        this(true);
    }

    public EslintExternalAnnotator(boolean onTheFly) {
        super(onTheFly);
    }

    @Override
    @NotNull
    protected JSLinterConfigurable<EslintState> createSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "createSettingsConfigurable"));
        }
        EslintConfigurable eslintConfigurable = new EslintConfigurable(project, true);
        if (eslintConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "createSettingsConfigurable"));
        }
        return eslintConfigurable;
    }

    @Override
    protected Class<EslintConfiguration> getConfigurationClass() {
        return EslintConfiguration.class;
    }

    @Override
    protected Class<EslintInspection> getInspectionClass() {
        return EslintInspection.class;
    }

    @Override
    protected boolean acceptPsiFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "acceptPsiFile"));
        }
        return file instanceof JSFile && JSUtils.isJavaScriptFile(file) || JSLinterUtil.isPureHtmlFile(file);
    }

    @Override
    @Nullable
    public Icon getFileLevelAnnotationDefaultIcon() {
        return JavaScriptLanguageIcons.FileTypes.Eslint;
    }

    @Override
    @Nullable
    public JSLinterAnnotationResult<EslintState> annotate(@NotNull JSLinterInput<EslintState> input) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "annotate"));
        }
        return new EsLintExternalRunner(this.isOnTheFly(), false).execute(input);
    }

    @Override
    public void apply(@NotNull PsiFile file, final @Nullable JSLinterAnnotationResult<EslintState> annotationResult, @NotNull AnnotationHolder holder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "apply"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "apply"));
        }
        new JSLinterAnnotationsBuilder<EslintState>(file, annotationResult, holder, EslintInspection.getHighlightDisplayKey(), new EslintConfigurable(file.getProject(), true), "ESLint: ").setHighlightingGranularity(JSLinterExternalAnnotator.HighlightingGranularity.element).setFixCreator(new JSLinterAnnotationsBuilder.JSLinterFixCreator(){

            @Override
            public boolean useDefaultNavigateToConfigOrShowSettings(JSLinterErrorBase errorBase) {
                return annotationResult != null;
            }

            @Override
            @Nullable
            public List<IntentionAction> createFixes(JSLinterErrorBase errorBase) {
                return Collections.singletonList(new EsLintFixFix());
            }
        }).apply();
    }

    public static class EsLintFixFix
    extends BaseIntentionAction {
        @NotNull
        public String getText() {
            String string = "Fix current file with " + JSBundle.message((String)"settings.javascript.linters.eslint.configurable.name", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator$EsLintFixFix", "getText"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"settings.javascript.linters.configurable.name", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator$EsLintFixFix", "getFamilyName"));
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator$EsLintFixFix", "isAvailable"));
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator$EsLintFixFix", "invoke"));
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            ProgressManager.getInstance().run((Task)new EsLintReformatterTask(project, Collections.singletonList(file.getVirtualFile())));
        }
    }
}

