/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsqtProcessOutputViewer {
    private JsqtProcessOutputViewer() {
    }

    public static void show(@NotNull Project project, @NotNull String title, @Nullable Icon icon, @NotNull GeneralCommandLine commandLine, @NotNull ProcessHandler handler, @NotNull ProcessOutput output) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JsqtProcessOutputViewer", "show"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/lang/javascript/linter/JsqtProcessOutputViewer", "show"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/lang/javascript/linter/JsqtProcessOutputViewer", "show"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/lang/javascript/linter/JsqtProcessOutputViewer", "show"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/lang/javascript/linter/JsqtProcessOutputViewer", "show"));
        }
        RunContentManager runContentManager = ExecutionManager.getInstance((Project)project).getContentManager();
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        RunContentDescriptor descriptor = JsqtProcessOutputViewer.createDescriptor(project, title, icon, commandLine, handler, output, executor);
        runContentManager.showRunContent(executor, descriptor);
    }

    @NotNull
    private static RunContentDescriptor createDescriptor(@NotNull Project project, @NotNull String title, @Nullable Icon icon, @NotNull GeneralCommandLine commandLine, @NotNull ProcessHandler handler, @NotNull ProcessOutput output, @NotNull Executor executor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JsqtProcessOutputViewer", "createDescriptor"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/lang/javascript/linter/JsqtProcessOutputViewer", "createDescriptor"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/lang/javascript/linter/JsqtProcessOutputViewer", "createDescriptor"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/lang/javascript/linter/JsqtProcessOutputViewer", "createDescriptor"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/lang/javascript/linter/JsqtProcessOutputViewer", "createDescriptor"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/lang/javascript/linter/JsqtProcessOutputViewer", "createDescriptor"));
        }
        ConsoleView view = JsqtProcessOutputViewer.createConsoleView(project);
        if (!handler.isProcessTerminated()) {
            view.attachToProcess(handler);
            ProcessTerminatedListener.attach((ProcessHandler)handler);
        }
        JsqtProcessOutputViewer.fillContents(view, commandLine, handler, output);
        DefaultActionGroup actions = new DefaultActionGroup();
        AnAction stopAction = ActionManager.getInstance().getAction("Stop");
        if (stopAction != null) {
            actions.add(stopAction);
        }
        JPanel result = JsqtProcessOutputViewer.createPanel(view, actions);
        RunContentDescriptor descriptor = new RunContentDescriptor((ExecutionConsole)view, handler, (JComponent)result, title, icon);
        actions.addAll(view.createConsoleActions());
        actions.add((AnAction)new CloseAction(executor, descriptor, project));
        RunContentDescriptor runContentDescriptor = descriptor;
        if (runContentDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JsqtProcessOutputViewer", "createDescriptor"));
        }
        return runContentDescriptor;
    }

    @NotNull
    private static ConsoleView createConsoleView(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JsqtProcessOutputViewer", "createConsoleView"));
        }
        TextConsoleBuilder consoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        consoleBuilder.filters(new Filter[]{new NodeStackTraceFilter(project)});
        ConsoleView consoleView = consoleBuilder.getConsole();
        if (consoleView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JsqtProcessOutputViewer", "createConsoleView"));
        }
        return consoleView;
    }

    private static void fillContents(@NotNull ConsoleView view, @NotNull GeneralCommandLine commandLine, @NotNull ProcessHandler handler, @NotNull ProcessOutput output) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/lang/javascript/linter/JsqtProcessOutputViewer", "fillContents"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/lang/javascript/linter/JsqtProcessOutputViewer", "fillContents"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/lang/javascript/linter/JsqtProcessOutputViewer", "fillContents"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/lang/javascript/linter/JsqtProcessOutputViewer", "fillContents"));
        }
        view.print(commandLine.getCommandLineString(), ConsoleViewContentType.SYSTEM_OUTPUT);
        view.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        String stdout = output.getStdout();
        String stderr = output.getStderr();
        view.print(stdout, ConsoleViewContentType.NORMAL_OUTPUT);
        if (!(stdout.isEmpty() || stderr.isEmpty() || stdout.endsWith("\n"))) {
            view.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        }
        view.print(stderr, ConsoleViewContentType.ERROR_OUTPUT);
        if (handler.isProcessTerminated()) {
            view.print("\nProcess finished with exit code " + output.getExitCode() + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        }
    }

    @NotNull
    private static JPanel createPanel(@NotNull ConsoleView view, @NotNull DefaultActionGroup actions) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/lang/javascript/linter/JsqtProcessOutputViewer", "createPanel"));
        }
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/lang/javascript/linter/JsqtProcessOutputViewer", "createPanel"));
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)view.getComponent(), "Center");
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)actions, false);
        panel.add((Component)actionToolbar.getComponent(), "West");
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JsqtProcessOutputViewer", "createPanel"));
        }
        return jPanel;
    }
}

