/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.google.common.base.Joiner;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ExternalAnnotatorInspectionVisitor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.PairedUnfairLocalInspectionTool;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.ide.DataManager;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.linter.JSLinterConfigurable;
import com.intellij.lang.javascript.linter.JSLinterExternalAnnotator;
import com.intellij.lang.javascript.linter.JSLinterState;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLinterInspection<T extends JSLinterState>
extends JSInspection
implements PairedUnfairLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(JSLinterInspection.class);

    @NotNull
    protected abstract JSLinterExternalAnnotator<T> getExternalAnnotatorForBatchInspection();

    @NotNull
    public String getInspectionForBatchShortName() {
        String string = this.getShortName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterInspection", "getInspectionForBatchShortName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(ProblemsHolder holder, LocalInspectionToolSession session) {
        ExternalAnnotatorInspectionVisitor externalAnnotatorInspectionVisitor = new ExternalAnnotatorInspectionVisitor(holder, this.getExternalAnnotatorForBatchInspection(), this.myOnTheFly);
        if (externalAnnotatorInspectionVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterInspection", "createVisitor"));
        }
        return externalAnnotatorInspectionVisitor;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = JSBundle.message((String)"js.linters.inspection.group.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterInspection", "getGroupDisplayName"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        HyperlinkLabel settingsLink = this.createHyperLink();
        panel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        panel.add((Component)settingsLink);
        return panel;
    }

    @Override
    public boolean isEnabledByDefault() {
        return false;
    }

    @NotNull
    private HyperlinkLabel createHyperLink() {
        List<String> path = this.getSettingsPath();
        String title = Joiner.on((String)" / ").join(path);
        final HyperlinkLabel settingsLink = new HyperlinkLabel(title);
        settingsLink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            public void hyperlinkActivated(HyperlinkEvent e) {
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)settingsLink);
                Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
                if (project == null) {
                    LOG.warn("No project found in data context");
                    return;
                }
                JSLinterConfigurable configurable = JSLinterInspection.this.getExternalAnnotatorForBatchInspection().createSettingsConfigurable(project);
                Settings settings = (Settings)Settings.KEY.getData(dataContext);
                if (settings == null) {
                    configurable.showEditDialog();
                    return;
                }
                settings.select(settings.find(configurable.getId()));
            }
        });
        HyperlinkLabel hyperlinkLabel = settingsLink;
        if (hyperlinkLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterInspection", "createHyperLink"));
        }
        return hyperlinkLabel;
    }

    @NotNull
    protected List<String> getSettingsPath() {
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new String[]{JSBundle.message((String)"settings.javascript.root.configurable.name", (Object[])new Object[0]), JSBundle.message((String)"settings.javascript.linters.configurable.name", (Object[])new Object[0]), this.getDisplayName()});
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterInspection", "getSettingsPath"));
        }
        return arrayList;
    }

    @NotNull
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/JSLinterInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/lang/javascript/linter/JSLinterInspection", "checkFile"));
        }
        ProblemDescriptor[] problemDescriptorArray = ExternalAnnotatorInspectionVisitor.checkFileWithExternalAnnotator((PsiFile)file, (InspectionManager)manager, (boolean)isOnTheFly, this.getExternalAnnotatorForBatchInspection());
        if (problemDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterInspection", "checkFile"));
        }
        return problemDescriptorArray;
    }

    public static boolean isToolEnabled(@NotNull Project project, @NotNull Class<? extends JSLinterInspection> inspectionClass) {
        InspectionProfileImpl inspectionProfileImpl;
        HighlightDisplayKey key;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterInspection", "isToolEnabled"));
        }
        if (inspectionClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionClass", "com/intellij/lang/javascript/linter/JSLinterInspection", "isToolEnabled"));
        }
        InspectionProjectProfileManager manager = InspectionProjectProfileManager.getInstance((Project)project);
        InspectionProfileImpl inspectionProfile = manager.getCurrentProfile();
        boolean enabled = inspectionProfile.isToolEnabled(key = JSLinterInspection.getHighlightDisplayKeyByClass(inspectionClass));
        if (!enabled && (inspectionProfileImpl = JSLinterInspection.getInspectionProfileImpl(inspectionProfile)) != null) {
            List<ScopeToolState> toolStates = JSLinterInspection.getNonDefaultTools(project, inspectionProfileImpl, key);
            for (ScopeToolState state : toolStates) {
                if (!state.isEnabled()) continue;
                return true;
            }
        }
        return enabled;
    }

    @NotNull
    private static List<ScopeToolState> getNonDefaultTools(@NotNull Project project, @NotNull InspectionProfileImpl inspectionProfileImpl, @NotNull HighlightDisplayKey key) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterInspection", "getNonDefaultTools"));
        }
        if (inspectionProfileImpl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionProfileImpl", "com/intellij/lang/javascript/linter/JSLinterInspection", "getNonDefaultTools"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/javascript/linter/JSLinterInspection", "getNonDefaultTools"));
        }
        ToolsImpl toolsImpl = inspectionProfileImpl.getTools(key.getID(), project);
        if (toolsImpl == null) {
            List<ScopeToolState> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterInspection", "getNonDefaultTools"));
            }
            return list;
        }
        List toolStates = toolsImpl.getNonDefaultTools();
        List list = ContainerUtil.notNullize((List)toolStates);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterInspection", "getNonDefaultTools"));
        }
        return list;
    }

    public static boolean isToolEnabled(@NotNull Project project, @NotNull Class<? extends JSLinterInspection> inspectionClass, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterInspection", "isToolEnabled"));
        }
        if (inspectionClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionClass", "com/intellij/lang/javascript/linter/JSLinterInspection", "isToolEnabled"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/JSLinterInspection", "isToolEnabled"));
        }
        InspectionProjectProfileManager manager = InspectionProjectProfileManager.getInstance((Project)project);
        InspectionProfileImpl inspectionProfile = manager.getCurrentProfile();
        HighlightDisplayKey key = JSLinterInspection.getHighlightDisplayKeyByClass(inspectionClass);
        return inspectionProfile.isToolEnabled(key, (PsiElement)file);
    }

    public static void setToolEnabled(@NotNull Project project, @NotNull Class<? extends JSLinterInspection> inspectionClass, boolean enabled) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterInspection", "setToolEnabled"));
        }
        if (inspectionClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionClass", "com/intellij/lang/javascript/linter/JSLinterInspection", "setToolEnabled"));
        }
        InspectionProjectProfileManager manager = InspectionProjectProfileManager.getInstance((Project)project);
        InspectionProfileImpl inspectionProfile = manager.getCurrentProfile();
        HighlightDisplayKey key = JSLinterInspection.getHighlightDisplayKeyByClass(inspectionClass);
        String toolId = key.getID();
        InspectionProfileImpl inspectionProfileImpl = JSLinterInspection.getInspectionProfileImpl(inspectionProfile);
        if (inspectionProfileImpl != null) {
            List toolStates = inspectionProfileImpl.getNonDefaultTools(toolId, project);
            for (ScopeToolState state : toolStates) {
                state.setEnabled(enabled);
            }
            ScopeToolState state = inspectionProfileImpl.getToolDefaultState(toolId, project);
            state.setEnabled(enabled);
        }
        inspectionProfile.modifyProfile(model -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterInspection", "lambda$setToolEnabled$0"));
            }
            if (enabled) {
                model.enableTool(toolId, null, project);
            } else {
                model.disableTool(toolId, project);
            }
        });
    }

    @Nullable
    private static InspectionProfileImpl getInspectionProfileImpl(@NotNull InspectionProfileImpl profile) {
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/lang/javascript/linter/JSLinterInspection", "getInspectionProfileImpl"));
        }
        return profile.wasInitialized() ? profile : null;
    }

    @NotNull
    public static HighlightDisplayKey getHighlightDisplayKeyByClass(@NotNull Class<? extends JSLinterInspection> inspectionClass) {
        if (inspectionClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionClass", "com/intellij/lang/javascript/linter/JSLinterInspection", "getHighlightDisplayKeyByClass"));
        }
        String id = JSInspection.calcShortNameFromClass(inspectionClass);
        HighlightDisplayKey key = HighlightDisplayKey.find((String)id);
        if (key == null) {
            key = new HighlightDisplayKey(id, id);
        }
        HighlightDisplayKey highlightDisplayKey = key;
        if (highlightDisplayKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterInspection", "getHighlightDisplayKeyByClass"));
        }
        return highlightDisplayKey;
    }
}

