/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterConfigurable;
import com.intellij.lang.javascript.linter.JSLinterEditConfigFileAction;
import com.intellij.lang.javascript.linter.JSLinterEditSettingsAction;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterErrorBase;
import com.intellij.lang.javascript.linter.JSLinterExternalAnnotator;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterState;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLinterAnnotationsBuilder<T extends JSLinterState> {
    @NotNull
    private final PsiFile myFile;
    @Nullable
    private final JSLinterAnnotationResult<T> myResult;
    @NotNull
    private final AnnotationHolder myHolder;
    @NotNull
    private final HighlightDisplayKey myKey;
    @NotNull
    private final JSLinterConfigurable<T> myConfigurable;
    @NotNull
    private final String myPrefix;
    @NotNull
    private JSLinterExternalAnnotator.HighlightingGranularity myHighlightingGranularity;
    @Nullable
    private JSLinterFixCreator myFixCreator;
    private IntentionAction myDefaultFix;

    public JSLinterAnnotationsBuilder(@NotNull PsiFile file, @Nullable JSLinterAnnotationResult<T> annotationResult, @NotNull AnnotationHolder holder, @NotNull HighlightDisplayKey inspectionKey, @NotNull JSLinterConfigurable<T> configurable, @NotNull String errorPrefix) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "<init>"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "<init>"));
        }
        if (inspectionKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionKey", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "<init>"));
        }
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "<init>"));
        }
        if (errorPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorPrefix", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "<init>"));
        }
        this.myFile = file;
        this.myResult = annotationResult;
        this.myHolder = holder;
        this.myKey = inspectionKey;
        this.myConfigurable = configurable;
        this.myPrefix = errorPrefix;
        this.myHighlightingGranularity = JSLinterExternalAnnotator.HighlightingGranularity.none;
    }

    public void apply() {
        if (this.myResult == null) {
            return;
        }
        Document document = PsiDocumentManager.getInstance((Project)this.myFile.getProject()).getDocument(this.myFile);
        if (document == null) {
            return;
        }
        this.createDefaultFix();
        this.createFileLevelAnnotations();
        this.processLocalErrors(document);
    }

    private void processLocalErrors(Document document) {
        if (this.myResult == null) {
            return;
        }
        InspectionProjectProfileManager inspectionProjectProfileManager = InspectionProjectProfileManager.getInstance((Project)this.myFile.getProject());
        SeverityRegistrar severityRegistrar = inspectionProjectProfileManager.getSeverityRegistrar();
        HighlightSeverity defaultSeverity = JSLinterUtil.getSeverity(inspectionProjectProfileManager, this.myKey, this.myFile);
        EditorColorsScheme colorsScheme = this.myResult.getInput().getColorsScheme();
        Function severityTextAttributesProvider = severity -> JSLinterUtil.getTextAttributes(colorsScheme, severityRegistrar, severity);
        TextAttributes defaultSeverityTextAttributes = (TextAttributes)severityTextAttributesProvider.fun((Object)defaultSeverity);
        for (JSLinterError linterError : this.myResult.getErrors()) {
            Annotation annotation = JSLinterExternalAnnotator.createAnnotation(this.myHolder, this.myFile, document, linterError, this.myPrefix, 1, defaultSeverity, defaultSeverityTextAttributes, (Function<HighlightSeverity, TextAttributes>)severityTextAttributesProvider, this.myKey, this.myHighlightingGranularity);
            if (annotation == null) continue;
            this.registerFixes(annotation, linterError);
        }
    }

    private void createFileLevelAnnotations() {
        Annotation annotation;
        JSLinterErrorBase fileErrorMessage;
        if (this.myResult == null) {
            throw new AssertionError();
        }
        List<JSLinterErrorBase> warnings = this.myResult.getWarnings();
        if (warnings != null) {
            for (JSLinterErrorBase warning : warnings) {
                Annotation warningAnnotation = JSLinterUtil.createWarningAnnotation(this.myHolder, (PsiElement)this.myFile, this.myPrefix + warning.getDescription());
                if (warningAnnotation == null) continue;
                warningAnnotation.setFileLevelAnnotation(true);
                if (this.myResult.getConfigFile() == null) continue;
                this.registerFixes(warningAnnotation, warning);
            }
        }
        if ((fileErrorMessage = this.myResult.getFileWideErrorMessage()) != null && (annotation = JSLinterUtil.createErrorAnnotation(this.myHolder, (PsiElement)this.myFile, this.myPrefix + fileErrorMessage.getDescription())) != null) {
            annotation.setFileLevelAnnotation(true);
            this.registerFixes(annotation, fileErrorMessage);
        }
        List<JSLinterFileLevelAnnotation> fileLevelAnnotations = this.myResult.getFileLevelAnnotations();
        for (JSLinterFileLevelAnnotation fileLevelAnnotation : fileLevelAnnotations) {
            Annotation annotation2 = this.myHolder.createAnnotation(fileLevelAnnotation.getSeverity(), this.myResult.getInput().getPsiFile().getTextRange(), fileLevelAnnotation.getMessage(), null);
            Icon icon = fileLevelAnnotation.getIcon();
            if (icon != null) {
                annotation2.setGutterIconRenderer((GutterIconRenderer)new JSLinterGutterIconRenderer(icon));
            }
            annotation2.setNeedsUpdateOnTyping(false);
            annotation2.setFileLevelAnnotation(true);
            for (IntentionAction fix : fileLevelAnnotation.getFixes()) {
                annotation2.registerFix(fix, null, this.myKey);
            }
        }
    }

    private void registerFixes(@NotNull Annotation annotation, @NotNull JSLinterErrorBase error) {
        List<IntentionAction> fixes;
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "registerFixes"));
        }
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "registerFixes"));
        }
        if (this.myFixCreator == null || this.myFixCreator.useDefaultNavigateToConfigOrShowSettings(error)) {
            annotation.registerFix(this.myDefaultFix, null, this.myKey);
        }
        if (this.myFixCreator != null && (fixes = this.myFixCreator.createFixes(error)) != null) {
            for (IntentionAction fix : fixes) {
                annotation.registerFix(fix, null, this.myKey);
            }
        }
    }

    private void createDefaultFix() {
        this.myDefaultFix = this.myResult.getConfigFile() != null ? new JSLinterEditConfigFileAction(this.myResult.getConfigFile(), null) : new JSLinterEditSettingsAction(this.myConfigurable);
    }

    public JSLinterAnnotationsBuilder<T> setHighlightingGranularity(@NotNull JSLinterExternalAnnotator.HighlightingGranularity highlightingGranularity) {
        if (highlightingGranularity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightingGranularity", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "setHighlightingGranularity"));
        }
        this.myHighlightingGranularity = highlightingGranularity;
        return this;
    }

    public JSLinterAnnotationsBuilder<T> setFixCreator(@Nullable JSLinterFixCreator fixCreator) {
        this.myFixCreator = fixCreator;
        return this;
    }

    private static class JSLinterGutterIconRenderer
    extends GutterIconRenderer
    implements DumbAware {
        private final Icon myIcon;

        public JSLinterGutterIconRenderer(@NotNull Icon icon) {
            if (icon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder$JSLinterGutterIconRenderer", "<init>"));
            }
            this.myIcon = icon;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = this.myIcon;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder$JSLinterGutterIconRenderer", "getIcon"));
            }
            return icon;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            JSLinterGutterIconRenderer renderer = (JSLinterGutterIconRenderer)((Object)o);
            return this.myIcon == renderer.myIcon;
        }

        public int hashCode() {
            return System.identityHashCode(this.myIcon);
        }
    }

    public static interface JSLinterFixCreator {
        public boolean useDefaultNavigateToConfigOrShowSettings(JSLinterErrorBase var1);

        @Nullable
        public List<IntentionAction> createFixes(JSLinterErrorBase var1);
    }
}

