/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class JSPredefinedLibraryProvider {
    public static final ExtensionPointName<JSPredefinedLibraryProvider> EP_NAME = ExtensionPointName.create((String)"JavaScript.predefinedLibraryProvider");

    @NotNull
    public ScriptingLibraryModel[] getPredefinedLibraries() {
        if (ScriptingLibraryModel.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSPredefinedLibraryProvider", "getPredefinedLibraries"));
        }
        return ScriptingLibraryModel.EMPTY_ARRAY;
    }

    @NotNull
    public ScriptingLibraryModel[] getPredefinedLibraries(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/JSPredefinedLibraryProvider", "getPredefinedLibraries"));
        }
        ScriptingLibraryModel[] scriptingLibraryModelArray = this.getPredefinedLibraries();
        if (scriptingLibraryModelArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSPredefinedLibraryProvider", "getPredefinedLibraries"));
        }
        return scriptingLibraryModelArray;
    }

    @NotNull
    public Set<VirtualFile> getPredefinedLibraryFiles() {
        Set<VirtualFile> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSPredefinedLibraryProvider", "getPredefinedLibraryFiles"));
        }
        return set;
    }

    @NotNull
    public Set<VirtualFile> getRequiredLibraryFiles() {
        Set<VirtualFile> set = this.getPredefinedLibraryFiles();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSPredefinedLibraryProvider", "getRequiredLibraryFiles"));
        }
        return set;
    }

    @NotNull
    public Map<String, String> getPredefinedLibraryRenamingMap() {
        Map<String, String> map = Collections.emptyMap();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSPredefinedLibraryProvider", "getPredefinedLibraryRenamingMap"));
        }
        return map;
    }

    @NotNull
    public static Set<ScriptingLibraryModel> getAllPredefinedLibraries(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/JSPredefinedLibraryProvider", "getAllPredefinedLibraries"));
        }
        HashSet allLibraries = new HashSet();
        for (JSPredefinedLibraryProvider provider : (JSPredefinedLibraryProvider[])Extensions.getExtensions(EP_NAME)) {
            allLibraries.addAll(Arrays.asList(provider.getPredefinedLibraries(project)));
        }
        HashSet hashSet = allLibraries;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSPredefinedLibraryProvider", "getAllPredefinedLibraries"));
        }
        return hashSet;
    }

    @NotNull
    public static Set<VirtualFile> getAllPredefinedLibraryFiles() {
        Set<VirtualFile> set = JSPredefinedLibraryProvider.getAllRequiredLibraryFiles();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSPredefinedLibraryProvider", "getAllPredefinedLibraryFiles"));
        }
        return set;
    }

    @NotNull
    public static Set<VirtualFile> getAllRequiredLibraryFiles() {
        HashSet libFiles = new HashSet();
        for (JSPredefinedLibraryProvider provider : (JSPredefinedLibraryProvider[])Extensions.getExtensions(EP_NAME)) {
            libFiles.addAll(provider.getRequiredLibraryFiles());
        }
        HashSet hashSet = libFiles;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSPredefinedLibraryProvider", "getAllRequiredLibraryFiles"));
        }
        return hashSet;
    }
}

