/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.library.JSPredefinedLibraryProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPredefinedLibrariesData {
    private final Set<ScriptingLibraryModel> myLibraryModels;
    private final NotNullLazyValue<Set<VirtualFile>> myLibraryFiles;
    private final NotNullLazyValue<Map<String, VirtualFile>> myLibraryFileByNameMap;

    private JSPredefinedLibrariesData(final @NotNull Project project, final @NotNull Set<ScriptingLibraryModel> models, final @NotNull Set<VirtualFile> requiredFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/JSPredefinedLibrariesData", "<init>"));
        }
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/intellij/lang/javascript/library/JSPredefinedLibrariesData", "<init>"));
        }
        if (requiredFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredFiles", "com/intellij/lang/javascript/library/JSPredefinedLibrariesData", "<init>"));
        }
        this.myLibraryModels = models;
        this.myLibraryFiles = new NotNullLazyValue<Set<VirtualFile>>(){

            @NotNull
            protected Set<VirtualFile> compute() {
                HashSet result = ContainerUtil.newHashSet((Iterable)requiredFiles);
                JSLibraryMappings mappings = JSLibraryMappings.getInstance(project);
                for (ScriptingLibraryModel model : models) {
                    if (!model.shouldIndexSourcesWithoutMappings() && mappings.getMappingsByLibraryName(model.getName()).isEmpty()) continue;
                    result.addAll(model.getSourceFiles());
                }
                Set<VirtualFile> set = Collections.unmodifiableSet(result);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSPredefinedLibrariesData$1", "compute"));
                }
                return set;
            }
        };
        this.myLibraryFileByNameMap = new NotNullLazyValue<Map<String, VirtualFile>>(){

            @NotNull
            protected Map<String, VirtualFile> compute() {
                Set files = (Set)JSPredefinedLibrariesData.this.myLibraryFiles.getValue();
                Map map = ContainerUtilRt.newHashMap((int)files.size());
                for (VirtualFile file : files) {
                    map.put(file.getName(), file);
                }
                Map map2 = map;
                if (map2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSPredefinedLibrariesData$2", "compute"));
                }
                return map2;
            }
        };
    }

    @NotNull
    public Set<VirtualFile> getLibraryFiles() {
        Set set = (Set)this.myLibraryFiles.getValue();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSPredefinedLibrariesData", "getLibraryFiles"));
        }
        return set;
    }

    @NotNull
    public Set<ScriptingLibraryModel> getLibraryModels() {
        Set<ScriptingLibraryModel> set = this.myLibraryModels;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSPredefinedLibrariesData", "getLibraryModels"));
        }
        return set;
    }

    @Nullable
    public VirtualFile findPredefinedFileByName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/lang/javascript/library/JSPredefinedLibrariesData", "findPredefinedFileByName"));
        }
        return (VirtualFile)((Map)this.myLibraryFileByNameMap.getValue()).get(fileName);
    }

    public boolean isPredefinedFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/JSPredefinedLibrariesData", "isPredefinedFile"));
        }
        return ((Set)this.myLibraryFiles.getValue()).contains(file);
    }

    @NotNull
    public static JSPredefinedLibrariesData create(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/JSPredefinedLibrariesData", "create"));
        }
        Set<ScriptingLibraryModel> models = JSPredefinedLibraryProvider.getAllPredefinedLibraries(project);
        Set<VirtualFile> requiredFiles = JSPredefinedLibraryProvider.getAllRequiredLibraryFiles();
        JSPredefinedLibrariesData jSPredefinedLibrariesData = new JSPredefinedLibrariesData(project, models, requiredFiles);
        if (jSPredefinedLibrariesData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSPredefinedLibrariesData", "create"));
        }
        return jSPredefinedLibrariesData;
    }
}

