/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSPredefinedLibraryFilesConverter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.xml.util.HtmlUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLibraryUtil {
    public static final Logger LOG = Logger.getInstance(JSLibraryUtil.class);
    public static final String[] MIN_SUFFIXES = new String[]{".min.", "-min.", "-yui-compressed"};
    public static final HashMap<String, String> MIN_TO_DEV_VERSION_MAP = new HashMap();
    public static final String NODE_MODULES = "node_modules";
    public static final String BOWER_COMPONENTS = "bower_components";
    public static final String JSPM_PACKAGES = "jspm_packages";
    public static final String[] LIBRARY_DIR_NAMES = new String[]{"node_modules", "bower_components", "jspm_packages"};
    private static final String JS_EXT = ".js";
    private static final String[] HTTP_PREFIXES;

    private JSLibraryUtil() {
    }

    public static boolean containsLibURL(String location) {
        return HtmlUtil.hasHtmlPrefix((String)location) && location.endsWith(JS_EXT);
    }

    public static String getDevVersionLocation(@NotNull String location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/lang/javascript/library/JSLibraryUtil", "getDevVersionLocation"));
        }
        if (!location.endsWith(JS_EXT)) {
            return location;
        }
        String oldFileName = JSLibraryUtil.extractFileName(location);
        String fileName = oldFileName;
        if (MIN_TO_DEV_VERSION_MAP.containsKey((Object)fileName)) {
            return location.replace(oldFileName, (CharSequence)MIN_TO_DEV_VERSION_MAP.get((Object)fileName));
        }
        for (String minSuffix : MIN_SUFFIXES) {
            if (!fileName.contains(minSuffix)) continue;
            fileName = oldFileName.replace(minSuffix, ".");
            return location.replace(oldFileName, fileName);
        }
        return location;
    }

    public static String makeUniqueFileName(String filePath, boolean adjustFileName) {
        String path = filePath;
        for (String prefix : HTTP_PREFIXES) {
            if (!filePath.contains(prefix)) continue;
            path = filePath.replace(prefix, "http_");
            break;
        }
        if (adjustFileName) {
            String fileName = JSLibraryUtil.extractFileName(filePath);
            if (MIN_TO_DEV_VERSION_MAP.containsKey((Object)fileName)) {
                path = path.replace(fileName, (CharSequence)MIN_TO_DEV_VERSION_MAP.get((Object)fileName));
            } else {
                for (String minSuffix : MIN_SUFFIXES) {
                    if (!filePath.contains(minSuffix)) continue;
                    path = path.replace(minSuffix, ".");
                    break;
                }
            }
        }
        return path.replace('/', '_').replace('\\', '_');
    }

    public static String extractFileName(String filePath) {
        int fileSepIndex = filePath.lastIndexOf(47);
        if (fileSepIndex < 0) {
            fileSepIndex = filePath.lastIndexOf(File.separatorChar);
        }
        return fileSepIndex >= 0 ? filePath.substring(fileSepIndex + 1, filePath.length()) : filePath;
    }

    @Nullable
    public static String getCanonicalUrl(String path) {
        File file = new File(path);
        try {
            return VfsUtilCore.pathToUrl((String)file.getCanonicalPath());
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getLibName(String location) {
        int dotIndex;
        String libName = JSLibraryUtil.extractFileName(location);
        if (!MIN_TO_DEV_VERSION_MAP.containsKey((Object)libName)) {
            for (String minSuffix : MIN_SUFFIXES) {
                if (!libName.contains(minSuffix)) continue;
                libName = libName.replace(minSuffix, ".");
                break;
            }
        }
        if ((dotIndex = libName.lastIndexOf(46)) >= 0) {
            libName = libName.substring(0, dotIndex);
        }
        return libName;
    }

    public static boolean isProbableLibraryFile(@NotNull VirtualFile file, @Nullable Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/JSLibraryUtil", "isProbableLibraryFile"));
        }
        return JSLibraryUtil.isProbableLibraryFile(file, project == null ? null : project.getBaseDir());
    }

    public static boolean isProbableLibraryFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/JSLibraryUtil", "isProbableLibraryFile"));
        }
        return JSLibraryUtil.isPredefinedLibraryFile(file) || JSLibraryUtil.hasDirectoryInPath(file, LIBRARY_DIR_NAMES, null);
    }

    public static boolean isProbableLibraryFile(@NotNull VirtualFile file, @Nullable VirtualFile fileToStop) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/JSLibraryUtil", "isProbableLibraryFile"));
        }
        return JSLibraryUtil.isPredefinedLibraryFile(file) || JSLibraryUtil.hasDirectoryInPath(file, LIBRARY_DIR_NAMES, fileToStop);
    }

    private static boolean isPredefinedLibraryFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/JSLibraryUtil", "isPredefinedLibraryFile"));
        }
        return JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles().contains(file);
    }

    public static VirtualFile getTopLibraryFolder(@NotNull VirtualFile file, @NotNull String libraryFolder, @Nullable VirtualFile stopFolder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/JSLibraryUtil", "getTopLibraryFolder"));
        }
        if (libraryFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryFolder", "com/intellij/lang/javascript/library/JSLibraryUtil", "getTopLibraryFolder"));
        }
        VirtualFile currentTarget = file;
        VirtualFile current = file;
        VirtualFile candidate;
        while ((candidate = JSLibraryUtil.getLibraryFolder(currentTarget, libraryFolder)) != null && (stopFolder == null || VfsUtilCore.isAncestor((VirtualFile)stopFolder, (VirtualFile)candidate, (boolean)true))) {
            current = candidate;
            if (current.getParent() == null || current.getParent().getParent() == null) {
                return current;
            }
            currentTarget = current.getParent().getParent();
        }
        return current;
    }

    public static VirtualFile getLibraryFolder(@NotNull VirtualFile file, @NotNull String libraryFolder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/JSLibraryUtil", "getLibraryFolder"));
        }
        if (libraryFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryFolder", "com/intellij/lang/javascript/library/JSLibraryUtil", "getLibraryFolder"));
        }
        for (VirtualFile current = file; current != null; current = current.getParent()) {
            CharSequence parentName;
            CharSequence charSequence = parentName = current.getParent() == null ? null : current.getParent().getNameSequence();
            if (!StringUtil.equals((CharSequence)libraryFolder, (CharSequence)parentName)) continue;
            return current;
        }
        return null;
    }

    public static boolean hasDirectoryInPath(@NotNull VirtualFile file, @NotNull String[] dirNames, @Nullable VirtualFile fileToStop) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/JSLibraryUtil", "hasDirectoryInPath"));
        }
        if (dirNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirNames", "com/intellij/lang/javascript/library/JSLibraryUtil", "hasDirectoryInPath"));
        }
        for (VirtualFile parent = file.getParent(); !(parent == null || fileToStop != null && parent.equals(fileToStop)); parent = parent.getParent()) {
            CharSequence name = parent.getNameSequence();
            for (String dirName : dirNames) {
                if (!StringUtil.equals((CharSequence)dirName, (CharSequence)name)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasDirectoryInPath(@NotNull VirtualFile file, @NotNull String directoryName, @Nullable VirtualFile fileToStop) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/JSLibraryUtil", "hasDirectoryInPath"));
        }
        if (directoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryName", "com/intellij/lang/javascript/library/JSLibraryUtil", "hasDirectoryInPath"));
        }
        for (VirtualFile parent = file.getParent(); !(parent == null || fileToStop != null && parent.equals(fileToStop)); parent = parent.getParent()) {
            if (!StringUtil.equals((CharSequence)directoryName, (CharSequence)parent.getNameSequence())) continue;
            return true;
        }
        return false;
    }

    public static boolean isProbableLibraryPath(@NotNull String file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/JSLibraryUtil", "isProbableLibraryPath"));
        }
        String name = FileUtil.toSystemDependentName((String)file);
        for (String s : FileUtil.splitPath((String)name)) {
            if (!ArrayUtil.contains((String)s, (String[])LIBRARY_DIR_NAMES)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static VirtualFile findFileByIoFile(@NotNull LocalFileSystem localFileSystem, @NotNull File ioFile) {
        if (localFileSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localFileSystem", "com/intellij/lang/javascript/library/JSLibraryUtil", "findFileByIoFile"));
        }
        if (ioFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ioFile", "com/intellij/lang/javascript/library/JSLibraryUtil", "findFileByIoFile"));
        }
        if (!ioFile.isFile()) {
            LOG.warn("Cannot find " + ioFile.getAbsolutePath() + ", the installation is possibly broken.");
            return null;
        }
        VirtualFile file = localFileSystem.findFileByIoFile(ioFile);
        if (file != null && file.isValid()) {
            return file;
        }
        LOG.warn("Cannot find virtual file for " + ioFile.getAbsolutePath());
        return null;
    }

    @Nullable
    public static VirtualFile convertFile(@Nullable VirtualFile file) {
        if (file != null) {
            for (JSPredefinedLibraryFilesConverter converter : (JSPredefinedLibraryFilesConverter[])JSPredefinedLibraryFilesConverter.EP_NAME.getExtensions()) {
                file = converter.convert(file);
            }
        }
        return file;
    }

    @Contract(value="_, null, _-> null")
    @Nullable
    public static VirtualFile cacheFile(@NotNull String libFileName, @Nullable VirtualFile file, @NotNull Map<String, Ref<VirtualFile>> cache) {
        if (libFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libFileName", "com/intellij/lang/javascript/library/JSLibraryUtil", "cacheFile"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/lang/javascript/library/JSLibraryUtil", "cacheFile"));
        }
        VirtualFile convertFile = JSLibraryUtil.convertFile(file);
        cache.put(libFileName, (Ref<VirtualFile>)Ref.create((Object)convertFile));
        return convertFile;
    }

    static {
        MIN_TO_DEV_VERSION_MAP.put((Object)"dojo.xd.js", (Object)"dojo.xd.js.uncompressed.js");
        MIN_TO_DEV_VERSION_MAP.put((Object)"dojo.js", (Object)"dojo.js.uncompressed.js");
        MIN_TO_DEV_VERSION_MAP.put((Object)"ext-core.js", (Object)"ext-core-debug.js");
        MIN_TO_DEV_VERSION_MAP.put((Object)"swfobject.js", (Object)"swfobject_src.js");
        MIN_TO_DEV_VERSION_MAP.put((Object)"webfont.js", (Object)"webfont_debug.js");
        HTTP_PREFIXES = new String[]{"http://", "https://"};
    }
}

