/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLibReferenceResolver {
    private JSLibReferenceResolver() {
    }

    @Nullable
    public static PsiReference getLibReference(XmlAttributeValue attributeValue) {
        PsiReference[] refs;
        for (PsiReference ref : refs = attributeValue.getReferences()) {
            if (!(ref instanceof JSLibReference)) continue;
            return ref;
        }
        return null;
    }

    public static JSLibReference createReference(XmlAttributeValue attributeValue) {
        return new JSLibReference(attributeValue);
    }

    public static class JSLibReference
    implements PsiReference {
        private final XmlAttributeValue myAttributeValue;
        private final Project myProject;

        public JSLibReference(XmlAttributeValue attributeValue) {
            this.myProject = attributeValue.getProject();
            this.myAttributeValue = attributeValue;
        }

        public PsiElement getElement() {
            return this.myAttributeValue;
        }

        public TextRange getRangeInElement() {
            TextRange absValueRange = this.myAttributeValue.getValueTextRange();
            int offset = this.myAttributeValue.getTextRange().getStartOffset();
            return new TextRange(absValueRange.getStartOffset() - offset, absValueRange.getEndOffset() - offset);
        }

        public PsiElement resolve() {
            return JSLibReference.resolveToLibrary(this.myAttributeValue.getValue(), this.myProject);
        }

        @Nullable
        public static PsiElement resolveToLibrary(String libName, Project project) {
            JSLibraryManager libraryManager = (JSLibraryManager)((Object)ServiceManager.getService((Project)project, JSLibraryManager.class));
            VirtualFile vf = libraryManager.getMatchingFile(JSLibraryUtil.makeUniqueFileName(libName, true));
            if (vf == null) {
                vf = libraryManager.getMatchingFile(JSLibraryUtil.makeUniqueFileName(libName, false));
            }
            if (vf != null && !vf.isValid()) {
                vf = JSLibReference.findNewVirtualFile(vf);
            }
            if (vf != null) {
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                return psiManager.findFile(vf);
            }
            return null;
        }

        @Nullable
        private static VirtualFile findNewVirtualFile(final @NotNull VirtualFile vf) {
            if (vf == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vf", "com/intellij/lang/javascript/library/JSLibReferenceResolver$JSLibReference", "findNewVirtualFile"));
            }
            return (VirtualFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile>(){

                public VirtualFile compute() {
                    VirtualFileSystem fileSystem = vf.getFileSystem();
                    VirtualFile newVf = fileSystem.findFileByPath(vf.getPath());
                    if (newVf != null && newVf.isValid()) {
                        return newVf;
                    }
                    return null;
                }
            });
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.myAttributeValue.getValue();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSLibReferenceResolver$JSLibReference", "getCanonicalText"));
            }
            return string;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            throw new IncorrectOperationException();
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/library/JSLibReferenceResolver$JSLibReference", "bindToElement"));
            }
            throw new IncorrectOperationException();
        }

        public boolean isReferenceTo(PsiElement element) {
            return false;
        }

        @NotNull
        public Object[] getVariants() {
            Object[] objectArray = new JSLibReference[]{};
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSLibReferenceResolver$JSLibReference", "getVariants"));
            }
            return objectArray;
        }

        public boolean isSoft() {
            return true;
        }
    }
}

