/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.BeforeAfter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LebabTestConvertor {
    private final List<Pair<String, BeforeAfter<String>>> myTests;
    private final List<Pair<String, String>> myDisabledTests;
    private final File myDir;
    private String myFirst;
    private String mySecond;

    public LebabTestConvertor(File dir) {
        this.myDir = dir;
        this.myTests = new ArrayList<Pair<String, BeforeAfter<String>>>();
        this.myDisabledTests = new ArrayList<Pair<String, String>>();
    }

    public static void main(String[] args) throws IOException {
        File before;
        LebabTestConvertor convertor = new LebabTestConvertor(new File(args[0]));
        convertor.executeMe();
        convertor.myDir.mkdirs();
        int i = 1;
        for (Pair<String, BeforeAfter<String>> pair : convertor.myTests) {
            before = new File(convertor.myDir, "before" + i + ".js");
            File after = new File(convertor.myDir, "after" + i + ".js");
            StringBuilder sbB = new StringBuilder();
            StringBuilder sbA = new StringBuilder();
            sbB.append("// \"Convert to let/const\" \"true\"\n");
            sbA.append("// \"Convert to let/const\" \"true\"\n");
            String beforeText = (String)((BeforeAfter)pair.getSecond()).getBefore();
            beforeText = LebabTestConvertor.addCaret(beforeText);
            sbB.append((String)pair.getFirst()).append('\n').append(beforeText);
            sbA.append((String)pair.getFirst()).append('\n').append((String)((BeforeAfter)pair.getSecond()).getAfter());
            FileUtil.writeToFile((File)before, (String)sbB.toString());
            FileUtil.writeToFile((File)after, (String)sbA.toString());
            ++i;
        }
        for (Pair pair : convertor.myDisabledTests) {
            before = new File(convertor.myDir, "beforeFalse" + i + ".js");
            StringBuilder sbB = new StringBuilder();
            sbB.append("// \"Convert to let/const\" \"false\"\n");
            String beforeText = (String)pair.getSecond();
            beforeText = LebabTestConvertor.addCaret(beforeText);
            sbB.append((String)pair.getFirst()).append('\n').append(beforeText);
            FileUtil.writeToFile((File)before, (String)sbB.toString());
            ++i;
        }
    }

    @NotNull
    private static String addCaret(String beforeText) {
        int varIdx = beforeText.indexOf("var ");
        if (varIdx >= 0) {
            beforeText = beforeText.substring(0, varIdx) + "<caret>" + beforeText.substring(varIdx);
        } else {
            int constIdx = beforeText.indexOf("const ");
            if (constIdx >= 0) {
                beforeText = beforeText.substring(0, constIdx) + "<caret>" + beforeText.substring(constIdx);
            } else {
                int letIdx = beforeText.indexOf("let ");
                if (letIdx >= 0) {
                    beforeText = beforeText.substring(0, letIdx) + "<caret>" + beforeText.substring(letIdx);
                }
            }
        }
        String string = beforeText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/LebabTestConvertor", "addCaret"));
        }
        return string;
    }

    private void describe(String name, Runnable runnable) {
        this.myFirst = name;
        runnable.run();
    }

    private void it(String name, Runnable runnable) {
        this.mySecond = name;
        runnable.run();
    }

    private void expect(String was, String become) {
        this.myTests.add((Pair<String, BeforeAfter<String>>)Pair.create((Object)this.comments(), (Object)new BeforeAfter((Object)was, (Object)become)));
    }

    @NotNull
    private String comments() {
        String string = "//" + this.myFirst + "\n//" + this.mySecond;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/LebabTestConvertor", "comments"));
        }
        return string;
    }

    private void expectNoChange(String s) {
        this.myDisabledTests.add((Pair<String, String>)Pair.create((Object)this.comments(), (Object)s));
    }

    private void executeMe() {
        this.describe("with uninitialized variable", () -> {
            this.it("should use let when never used afterwards", () -> this.expect("var x;", "let x;"));
            this.it("should use let when assigned aftwerwards", () -> this.expect("var x;\nx = 6;", "let x;\nx = 6;"));
        });
        this.describe("with initialized variable", () -> {
            this.it("should use const when never used afterwards", () -> this.expect("var x = 2;", "const x = 2;"));
            this.it("should use const when only referenced afterwards", () -> this.expect("var x = 2;\nfoo(x);", "const x = 2;\nfoo(x);"));
            this.it("should use let when re-assigned afterwards", () -> this.expect("var x = 5;\nx = 6;", "let x = 5;\nx = 6;"));
            this.it("should use let when updated aftwerwards", () -> this.expect("var x = 5;\nx++;", "let x = 5;\nx++;"));
            this.it("should handle variables names identical to Object prototype methods", () -> this.expect("var constructor = 1;\nvar toString = 1;\nvar valueOf = 1;\nvar hasOwnProperty = 1;", "const constructor = 1;\nconst toString = 1;\nconst valueOf = 1;\nconst hasOwnProperty = 1;"));
        });
        this.describe("with multi-variable declaration", () -> {
            this.it("should use const when not referenced afterwards", () -> this.expect("var x = 1, y = 2;", "const x = 1, y = 2;"));
            this.it("should use let when assigned to afterwards", () -> this.expect("var x = 1, y = 2;\nx = 3;\ny = 4;", "let x = 1, y = 2;\nx = 3;\ny = 4;"));
            this.it("should use let when initially unassigned but assigned afterwards", () -> this.expect("var x, y;\nx = 3;\ny = 4;", "let x, y;\nx = 3;\ny = 4;"));
            this.it("should split to let & const when only some vars assigned to afterwards", () -> this.expect("var x = 1, y = 2;\ny = 4;", "const x = 1;\nlet y = 2;\ny = 4;"));
            this.it("should split to let & var when only some vars are block-scoped", () -> this.expect("if (true) {\n  var x = 1, y = 2;\n  x = 10;\n}\ny = 20;", "if (true) {\n  let x = 1;\n  var y = 2;\n  x = 10;\n}\ny = 20;"));
            this.it("should split to let & const inside switch case", () -> this.expect("switch (nr) {\ncase 15:\n  var x = 1, y = 2;\n  x++;\n}", "switch (nr) {\ncase 15:\n  let x = 1;\n  const y = 2;\n  x++;\n}"));
        });
        this.describe("with multi-variable declaration in restrictive parent", () -> {
            this.it("should use const when all consts in if-statement", () -> this.expect("if (true) var x = 1, y = 2", "if (true) const x = 1, y = 2;"));
            this.it("should use let when both let & const in if-statement", () -> this.expect("if (true) var x = 1, y = ++x;", "if (true) let x = 1, y = ++x;"));
            this.it("should use var when both var & const in if-statement", () -> this.expect("if (false) {\n  if (true) var x = 1, y = ++x;\n}\nfoo(x);", "if (false) {\n  if (true) var x = 1, y = ++x;\n}\nfoo(x);"));
            this.it("should use let when both let & const in else-side of if-statement", () -> this.expect("if (true); else var x = 1, y = ++x;", "if (true); else let x = 1, y = ++x;"));
            this.it("should use let when both let & const in for-loop head", () -> this.expect("for (var i=0, len=arr.length; i<len; i++) {}", "for (let i=0, len=arr.length; i<len; i++) {}"));
            this.it("should use let when both let & const in for-in-loop body", () -> this.expect("for (item in array) var x = 1, y = ++x", "for (item in array) let x = 1, y = ++x"));
        });
        this.describe("with destructured variable declaration", () -> {
            this.it("should use const when not referenced afterwards", () -> this.expect("var [x, y] = [1, 2];\nvar {foo, bar} = {foo: 1, bar: 2};", "const [x, y] = [1, 2];\nconst {foo, bar} = {foo: 1, bar: 2};"));
            this.it("should use let when assigned to afterwards", () -> this.expect("var [x, y] = [1, 2];\nx = 3;\ny = 4;", "let [x, y] = [1, 2];\nx = 3;\ny = 4;"));
            this.it("should use let when only some vars assigned to afterwards", () -> this.expect("var [x, y] = [1, 2];\ny = 4;", "let [x, y] = [1, 2];\ny = 4;"));
            this.it("should use var when only some vars are block-scoped", () -> this.expectNoChange("if (true) {\n  var [x, y] = [1, 2];\n  x = 10;\n}\ny = 20;"));
        });
        this.describe("with nested function", () -> {
            this.it("should use let when variable re-declared inside it", () -> this.expect("var a = 0;\nfunction foo() { var a = 1; }\na = 2;", "let a = 0;\nfunction foo() { const a = 1; }\na = 2;"));
            this.it("should use let when variable assigned inside it", () -> this.expect("var a = 0;\nfunction foo() { a = 1; }", "let a = 0;\nfunction foo() { a = 1; }"));
            this.it("should use const when variable referenced inside it", () -> this.expect("var a = 0;\nfunction foo() { bar(a); }", "const a = 0;\nfunction foo() { bar(a); }"));
            this.it("should use const when variable redeclared as parameter", () -> this.expect("var a = 0;\nfunction foo(a) { a = 1; }", "const a = 0;\nfunction foo(a) { a = 1; }"));
        });
        this.describe("with nested arrow-function", () -> {
            this.it("should use let when variable re-declared inside it", () -> this.expect("var a = 0;\n() -> { var a = 1; };\na = 2;", "let a = 0;\n() -> { const a = 1; };\na = 2;"));
            this.it("should use let when variable assigned inside it", () -> this.expect("var a = 0;\n() -> { a = 1; };", "let a = 0;\n() -> { a = 1; };"));
            this.it("should use const when variable referenced inside it", () -> this.expect("var a = 0;\n() -> { bar(a); };", "const a = 0;\n() -> { bar(a); };"));
            this.it("should use const when variable redeclared as parameter", () -> this.expect("var a = 0;\n(a) -> a = 1;", "const a = 0;\n(a) -> a = 1;"));
        });
        this.describe("with nested function that uses destructured parmaters", () -> this.it("should use const when variable redeclared as parameter", () -> this.expect("var a = 0;\nfunction foo({a}) { a = 1; };", "const a = 0;\nfunction foo({a}) { a = 1; };")));
        this.describe("with nested block", () -> {
            this.it("should use let when variable assigned in it", () -> this.expect("var a = 0;\nif (true) { a = 1; }", "let a = 0;\nif (true) { a = 1; }"));
            this.it("should use const when variable referenced in it", () -> this.expect("var a = 0;\nif (true) { foo(a); }", "const a = 0;\nif (true) { foo(a); }"));
            this.it("should use let when variable only assigned inside a single block", () -> this.expect("if (true) {\n  var a = 1;\n  a = 2;\n}", "if (true) {\n  let a = 1;\n  a = 2;\n}"));
            this.it("should use const when variable only referenced inside a single block", () -> this.expect("if (true) {\n  var a = 1;\n  foo(a);\n}", "if (true) {\n  const a = 1;\n  foo(a);\n}"));
            this.it("should use let when variable assigned inside further nested block", () -> this.expect("if (true) {\n  var a = 1;\n  if (false) { a = 2; }\n}", "if (true) {\n  let a = 1;\n  if (false) { a = 2; }\n}"));
            this.it("should use const when variable referenced inside further nested block", () -> this.expect("if (true) {\n  var a = 1;\n  if (false) { foo(a); }\n}", "if (true) {\n  const a = 1;\n  if (false) { foo(a); }\n}"));
            this.it("should ignore variable declared inside a block but assigned outside", () -> this.expectNoChange("if (true) {\n  var a = 1;\n}\na += 1;"));
            this.it("should ignore variable declared inside a block but referenced outside", () -> this.expectNoChange("if (true) {\n  var a = 1;\n}\nfoo(a);"));
            this.it("should use const when variable name used in object property outside the block", () -> this.expect("if (true) {\n  var a = 1;\n}\nobj.a = 2;\nx = {a: 2};", "if (true) {\n  const a = 1;\n}\nobj.a = 2;\nx = {a: 2};"));
            this.it("should use const when variable name used as function expression name outside the block", () -> this.expect("if (true) {\n  var a = 1;\n}\nfn = function a() {}", "if (true) {\n  const a = 1;\n}\nfn = function a() {}"));
            this.it("should use const when variable name used as function parameter name outside the block", () -> this.expect("if (true) {\n  var a = 1;\n}\nfunction fn(a) {}", "if (true) {\n  const a = 1;\n}\nfunction fn(a) {}"));
            this.it("should use const when variable name used as arrow-function parameter name outside the block", () -> this.expect("if (true) {\n  var a = 1;\n}\nfn = (a) -> {};", "if (true) {\n  const a = 1;\n}\nfn = (a) -> {};"));
            this.it("should use const when variable name used as destructured function parameter name outside the block", () -> this.expect("if (true) {\n  var a = 1;\n}\nfunction fn({a}) {}", "if (true) {\n  const a = 1;\n}\nfunction fn({a}) {}"));
            this.it("should ignore variable referenced in function body outside the block", () -> this.expectNoChange("if (true) {\n  var a = 1;\n}\nfn = function() { return a; }"));
            this.it("should ignore variable referenced in shorthand arrow-function body outside the block", () -> this.expectNoChange("if (true) {\n  var a = 1;\n}\nfn = () -> a;"));
            this.it("should ignore variable referenced in variable declaration outside the block", () -> this.expectNoChange("if (true) {\n  var a = 1;\n}\nconst foo = a;"));
        });
        this.describe("in loop heads", () -> {
            this.it("should convert var in for-loop head to let", () -> this.expect("for (var i=0; i<10; i++) { foo(i); }", "for (let i=0; i<10; i++) { foo(i); }"));
            this.it("should convert var in for-in head to const", () -> this.expect("for (var key in obj) { foo(key); }", "for (const key in obj) { foo(key); }"));
            this.it("should convert var in for-of head to const", () -> this.expect("for (var item of array) { foo(item); }", "for (const item of array) { foo(item); }"));
            this.it("should ignore var in for-loop head that is referenced outside the loop", () -> this.expectNoChange("for (var i=0; i<10; i++) {}\nfoo(i);"));
            this.it("should ignore var in for-in-loop head that is referenced outside the loop", () -> this.expectNoChange("for (var key in obj) {}\nfoo(key);"));
            this.it("should ignore var in for-of-loop head that is referenced outside the loop", () -> this.expectNoChange("for (var item of array) {}\nfoo(item);"));
        });
        this.describe("with variable assigned before declared", () -> {
            this.it("should ignore", () -> this.expectNoChange("a = 1;\nvar a = 2;"));
            this.it("should ignore when similar variable in outer scope", () -> this.expect("var a = 0;\nfunction foo() {\n  a = 1;\n  var a = 2;\n}", "const a = 0;\nfunction foo() {\n  a = 1;\n  var a = 2;\n}"));
        });
        this.describe("with variable referenced before declared", () -> this.it("should ignore", () -> this.expectNoChange("foo(a);\nvar a = 2;")));
        this.describe("with repeated variable declarations", () -> {
            this.it("should ignore", () -> this.expectNoChange("var a = 1;\nvar a = 2;"));
            this.it("should ignore when declarations in different blocks", () -> this.expectNoChange("if (true) {\n  var a = 1;\n}\nif (true) {\n  var a;\n  foo(a);\n}"));
            this.it("should ignore when re-declaring of function parameter", () -> this.expectNoChange("function foo(a) {\n  var a = 1;\n}"));
            this.it("should ignore when re-declaring of destuctured function parameter", () -> this.expectNoChange("function foo({a}) {\n  var a = 1;\n}"));
            this.it("should ignore when re-declaring of function expression name", () -> this.expectNoChange("(function foo(a) {\n  var foo;\n  return foo;\n})();"));
            this.it("should allow re-declaring of function declaration name", () -> this.expect("function foo(a) {\n  var foo;\n  return foo;\n}", "function foo(a) {\n  let foo;\n  return foo;\n}"));
        });
        this.describe("with destructuring assignment", () -> {
            this.it("should use let when array destructuring used", () -> this.expect("var foo = 1;\n[foo] = [1, 2, 3];", "let foo = 1;\n[foo] = [1, 2, 3];"));
            this.it("should use let when object destructuring used", () -> this.expect("var foo = 1;\n({foo}) = {foo: 2};", "let foo = 1;\n({foo}) = {foo: 2};"));
            this.it("should use let when nested destructuring used", () -> this.expect("var foo = 1;\n[{foo}] = [{foo: 2}];", "let foo = 1;\n[{foo}] = [{foo: 2}];"));
            this.it("should use let for all variables modified through destructuring", () -> this.expect("var a = 1;\nvar b = 1;\nvar c = 1;\n[a, {foo: c}] = [3, {foo: 2}];", "let a = 1;\nconst b = 1;\nlet c = 1;\n[a, {foo: c}] = [3, {foo: 2}];"));
            this.it("should use const when name is used as property key in object destructor", () -> this.expect("var foo = 1;\n({foo: a}) = {foo: 2};", "const foo = 1;\n({foo: a}) = {foo: 2};"));
        });
        this.describe("existing let/const", () -> {
            this.it("should not convert existing let to const", () -> this.expectNoChange("let x = 1;"));
            this.it("should not convert existing const to var", () -> this.expectNoChange("if (true) {\n  const x = 1;\n} else {\n  const x = 2;\n}"));
            this.it("should not convert existing let to var", () -> this.expectNoChange("if (true) {\n  let x = 1;\n} else {\n  let x = 2;\n}"));
        });
        this.describe("regression tests", () -> {
            this.it("should not throw error for assignment to undeclared variable", () -> this.expectNoChange("x = 2;"));
            this.it("should not throw error for assignment to object property", () -> this.expectNoChange("this.y = 5;"));
            this.it("should use const when similarly-named property is assigned to", () -> this.expect("var x = 2;\nb.x += 1;", "const x = 2;\nb.x += 1;"));
            this.it("should use const when similarly-named property is updated", () -> this.expect("var x = 2;\nb.x++;", "const x = 2;\nb.x++;"));
        });
        this.describe("comments", () -> {
            this.it("should preserve comment line", () -> this.expect("// comment line\nvar x = 42;", "// comment line\nconst x = 42;"));
            this.it("should preserve trailing comment", () -> this.expect("var x = 42; // trailing comment", "const x = 42; // trailing comment"));
        });
    }
}

