/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JSSplitDeclarationIntention
extends JavaScriptIntention {
    public JSSplitDeclarationIntention() {
        this.setText(JSBundle.message((String)"js.split.into.multiple.declarations", (Object[])new Object[0]));
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSSplitDeclarationIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSSplitDeclarationIntention", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        JSVarStatement varStatement = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSVarStatement.class);
        if (varStatement != null) {
            JSVariable[] variables = varStatement.getVariables();
            return variables.length > 1;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSSplitDeclarationIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSSplitDeclarationIntention", "invoke"));
        }
        JSVarStatement varStatement = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSVarStatement.class);
        assert (varStatement != null);
        ASTNode varModifier = varStatement.getNode().findChildByType(JSTokenTypes.VAR_MODIFIERS);
        String varStatementKeyword = varModifier == null ? "var " : varModifier.getText() + " ";
        JSVariable[] variables = varStatement.getVariables();
        PsiElement parent = varStatement.getParent();
        JSVarStatement elem = varStatement;
        int variablesLength = variables.length;
        for (int i = 1; i < variablesLength; ++i) {
            JSVariable variable = variables[i];
            ASTNode jsTreeFromText = JSChangeUtil.createJSTreeFromText(project, varStatementKeyword + variable.getText() + ";", JSUtils.getDialect(element.getContainingFile()));
            PsiElement psi = jsTreeFromText.getPsi();
            if (psi == null) continue;
            elem = parent.addAfter(psi, (PsiElement)elem);
            elem = CodeStyleManager.getInstance((Project)project).reformat((PsiElement)elem);
        }
        varStatement.deleteChildRange(variables[0].getNode().getTreeNext().getPsi(), (PsiElement)variables[variablesLength - 1]);
    }

    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.split.declarations", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSSplitDeclarationIntention", "getFamilyName"));
        }
        return string;
    }
}

