/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommentsMover {
    private static boolean myAddNewLineInPlaceOfBeforeComments;
    private final List<PsiElement> myBeforeComments;
    private final List<PsiElement> myAfterComments;

    public CommentsMover(@NotNull JSSourceElement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/lang/javascript/intentions/CommentsMover", "<init>"));
        }
        this.myBeforeComments = CommentsMover.collectBeforeComments(statement);
        this.myAfterComments = CommentsMover.collectAfterComments(statement);
    }

    public void move(@NotNull Set<PsiElement> created, @NotNull Collection<PsiElement> touched) {
        if (created == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "created", "com/intellij/lang/javascript/intentions/CommentsMover", "move"));
        }
        if (touched == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "touched", "com/intellij/lang/javascript/intentions/CommentsMover", "move"));
        }
        if (this.myBeforeComments.isEmpty() && this.myAfterComments.isEmpty()) {
            return;
        }
        PsiElement min = Collections.min(created, Comparator.comparingInt(o -> o.getTextRange().getStartOffset()));
        if (min == null) {
            return;
        }
        if (!(min instanceof JSSourceElement)) {
            JSSourceElement statement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)min, JSSourceElement.class);
            if (statement == null) {
                return;
            }
            min = statement;
        }
        if (!this.myBeforeComments.isEmpty() && this.myBeforeComments.get(0) instanceof JSDocComment) {
            JSDocumentationUtils.moveJSDoc((PsiComment)this.myBeforeComments.get(0), min);
        } else {
            Collections.reverse(this.myBeforeComments);
            this.moveCommentsList(min, this.myBeforeComments, touched);
        }
        if (!this.myAfterComments.isEmpty()) {
            this.moveCommentsList(min.getNextSibling(), this.myAfterComments, touched);
        }
    }

    public boolean isLinkedComment(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/CommentsMover", "isLinkedComment"));
        }
        return this.myBeforeComments.contains(element) || this.myAfterComments.contains(element);
    }

    @Nullable
    public PsiElement getFirstBeforeComment() {
        return this.myBeforeComments == null || this.myBeforeComments.isEmpty() ? null : this.myBeforeComments.get(this.myBeforeComments.size() - 1);
    }

    @Nullable
    public PsiElement getLastAfterComment() {
        return this.myAfterComments == null || this.myAfterComments.isEmpty() ? null : this.myAfterComments.get(this.myAfterComments.size() - 1);
    }

    @NotNull
    private static List<PsiElement> collectBeforeComments(JSSourceElement statement) {
        ArrayList<PsiElement> comments = new ArrayList<PsiElement>();
        PsiComment comment = JSDocumentationUtils.findDocComment((PsiElement)statement);
        if (!(comment instanceof JSDocComment)) {
            JSSourceElement current = statement;
            PsiComment lastComment = null;
            while (current.getPrevSibling() instanceof PsiComment || current.getPrevSibling() instanceof PsiWhiteSpace) {
                comments.add(current.getPrevSibling());
                if (!((current = current.getPrevSibling()) instanceof PsiComment)) continue;
                lastComment = (PsiComment)current;
            }
            if (lastComment == null) {
                SmartList smartList = new SmartList();
                if (smartList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/CommentsMover", "collectBeforeComments"));
                }
                return smartList;
            }
            Document document = FileDocumentManager.getInstance().getDocument(lastComment.getContainingFile().getVirtualFile());
            if (document != null) {
                int endOffset;
                int startComment = document.getLineNumber(lastComment.getTextRange().getStartOffset());
                boolean addFirstLineBreak = true;
                int numBeforeCommentsLeft = 0;
                while (!lastComment.equals(comments.get(comments.size() - 1))) {
                    PsiElement lastSpace = (PsiElement)comments.get(comments.size() - 1);
                    int line = document.getLineNumber(lastSpace.getTextRange().getEndOffset());
                    if (line == startComment && !lastSpace.getText().endsWith("\n")) {
                        addFirstLineBreak = false;
                        break;
                    }
                    comments.remove(comments.size() - 1);
                    ++numBeforeCommentsLeft;
                }
                if (numBeforeCommentsLeft == 0) {
                    myAddNewLineInPlaceOfBeforeComments = true;
                }
                if (addFirstLineBreak) {
                    comments.add(CommentsMover.createNewLine((PsiElement)statement));
                }
                if (current.getPrevSibling() != null && startComment == document.getLineNumber(endOffset = current.getPrevSibling().getTextRange().getEndOffset())) {
                    PsiElement next;
                    ListIterator listIterator = comments.listIterator(comments.size());
                    while (listIterator.hasPrevious() && ((next = (PsiElement)listIterator.previous()) instanceof PsiWhiteSpace || lastComment.equals(next))) {
                        listIterator.remove();
                    }
                }
            }
        } else {
            comments.add((PsiElement)comment);
        }
        ArrayList<PsiElement> arrayList = comments;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/CommentsMover", "collectBeforeComments"));
        }
        return arrayList;
    }

    public static PsiElement createNewLine(PsiElement statement) {
        return CommentsMover.createWhiteSpace(statement, "\n");
    }

    public static PsiElement createWhiteSpace(PsiElement statement, @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/intentions/CommentsMover", "createWhiteSpace"));
        }
        return JSChangeUtil.createJSFileFromText(statement.getProject(), text, DialectDetector.languageDialectOfElement(statement)).getFirstChild();
    }

    @NotNull
    private static List<PsiElement> collectAfterComments(JSSourceElement statement) {
        ArrayList<PsiElement> comments = new ArrayList<PsiElement>();
        PsiComment commentsFound = null;
        JSSourceElement current = statement;
        while (current.getNextSibling() instanceof PsiComment || current.getNextSibling() instanceof PsiWhiteSpace) {
            comments.add(current.getNextSibling());
            current = current.getNextSibling();
            if (current instanceof PsiComment) {
                commentsFound = (PsiComment)current;
                continue;
            }
            if (!current.getText().contains("\n")) continue;
        }
        if (commentsFound == null || !statement.equals(CommentsMover.findAssociatedSameLineElementForComment(commentsFound))) {
            comments.clear();
        }
        ArrayList<PsiElement> arrayList = comments;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/CommentsMover", "collectAfterComments"));
        }
        return arrayList;
    }

    private void moveCommentsList(PsiElement min, List<PsiElement> comments, @NotNull Collection<PsiElement> touched) {
        if (touched == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "touched", "com/intellij/lang/javascript/intentions/CommentsMover", "moveCommentsList"));
        }
        if (comments.isEmpty()) {
            return;
        }
        for (PsiElement element : comments) {
            if (!element.isValid()) {
                return;
            }
            if (!(element instanceof PsiComment) || !touched.contains(CommentsMover.findAssociatedElementForComment((PsiComment)element))) continue;
            return;
        }
        JSChangeUtil.addComments(comments, min);
        PsiElement sibling = comments.get(comments.size() - 1).getNextSibling();
        boolean hasLineBreakAfter = sibling instanceof PsiWhiteSpace && sibling.getText().contains("\n");
        for (int i = 0; i < comments.size(); ++i) {
            PsiElement element = comments.get(i);
            if (i == 0 && myAddNewLineInPlaceOfBeforeComments && comments == this.myBeforeComments && !hasLineBreakAfter) {
                element.replace(CommentsMover.createNewLine(element));
                continue;
            }
            element.getParent().getNode().removeChild(element.getNode());
        }
    }

    static PsiElement findAssociatedSameLineElementForComment(PsiComment current) {
        Document document = PsiDocumentManager.getInstance((Project)current.getProject()).getDocument(current.getContainingFile());
        if (document == null) {
            return null;
        }
        int startLine = document.getLineNumber(current.getTextRange().getStartOffset());
        for (PsiElement currentOnLine = current.getPrevSibling(); currentOnLine != null && startLine == document.getLineNumber(currentOnLine.getTextRange().getStartOffset()); currentOnLine = currentOnLine.getPrevSibling()) {
            if (!(currentOnLine instanceof JSElement) || currentOnLine instanceof PsiComment) continue;
            return currentOnLine;
        }
        return null;
    }

    static PsiElement findAssociatedElementForComment(PsiComment current) {
        PsiElement sameLineElementForComment = CommentsMover.findAssociatedSameLineElementForComment(current);
        if (sameLineElementForComment != null) {
            return sameLineElementForComment;
        }
        return JSDocumentationUtils.findAttachedElementFromComment(current);
    }
}

