/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.lang.javascript.intentions.CommentsMover;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.ArrayDeque;

public class NewLineEraser {
    private final PsiElement myCause;
    private final PsiElement myPrev;
    private final PsiElement myNext;

    public NewLineEraser(PsiElement cause) {
        this.myCause = cause;
        this.myPrev = this.myCause.getPrevSibling();
        this.myNext = this.myCause.getNextSibling();
    }

    public void process() {
        if (this.myCause.isValid()) {
            return;
        }
        if (this.myPrev != null && this.myPrev.isValid() && this.myPrev instanceof PsiWhiteSpace) {
            NewLineEraser.zipNewLines((PsiWhiteSpace)this.myPrev);
            return;
        }
        if (this.myNext != null && this.myNext.isValid() && this.myNext instanceof PsiWhiteSpace) {
            NewLineEraser.zipNewLines((PsiWhiteSpace)this.myNext);
        }
    }

    private static void zipNewLines(PsiWhiteSpace space) {
        ArrayDeque<PsiWhiteSpace> spaces = new ArrayDeque<PsiWhiteSpace>();
        spaces.add(space);
        PsiElement current = space.getPrevSibling();
        while (current instanceof PsiWhiteSpace) {
            spaces.addFirst((PsiWhiteSpace)current);
            current = current.getPrevSibling();
        }
        current = space.getNextSibling();
        while (current instanceof PsiWhiteSpace) {
            spaces.addLast((PsiWhiteSpace)current);
            current = current.getNextSibling();
        }
        int cntNewLines = 0;
        for (PsiWhiteSpace whiteSpace : spaces) {
            String text = whiteSpace.getText();
            int newLines = StringUtil.countNewLines((CharSequence)text);
            if (newLines < 1) continue;
            if (cntNewLines + newLines > 1) {
                String newText = text.replaceFirst("\n", "");
                if (!newText.isEmpty()) {
                    whiteSpace.replace(CommentsMover.createWhiteSpace((PsiElement)whiteSpace, newText));
                    break;
                }
                whiteSpace.delete();
                break;
            }
            cntNewLines += newLines;
        }
    }
}

