/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSConsecutiveCommasInArrayLiteralInspection
extends JSInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.consecutive.commas.in.array.literal.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSConsecutiveCommasInArrayLiteralInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSArrayLiteralExpression(JSArrayLiteralExpression node) {
                PsiElement child = node.getFirstChild();
                while (child != null) {
                    PsiElement nextSibling = child.getNextSibling();
                    while (nextSibling instanceof PsiWhiteSpace || nextSibling instanceof PsiComment) {
                        nextSibling = nextSibling.getNextSibling();
                    }
                    if (nextSibling != null && child.getNode().getElementType() == JSTokenTypes.COMMA && nextSibling.getNode().getElementType() == JSTokenTypes.COMMA) {
                        holder.registerProblem((PsiElement)node, new TextRange(child.getStartOffsetInParent(), nextSibling.getStartOffsetInParent() + 1), JSBundle.message((String)"js.consecutive.commas.in.array.literal.inspection.message", (Object[])new Object[0]), new LocalQuickFix[]{JSFixFactory.getInstance().removeASTNodeFix("javascript.validation.message.remove.unneeded.comma.fix", child.getNode()), new InsertUndefinedFix(child)});
                    }
                    child = nextSibling;
                }
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSConsecutiveCommasInArrayLiteralInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    private static class InsertUndefinedFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        protected InsertUndefinedFix(@Nullable PsiElement element) {
            super(element);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/JSConsecutiveCommasInArrayLiteralInspection$InsertUndefinedFix", "invoke"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/inspections/JSConsecutiveCommasInArrayLiteralInspection$InsertUndefinedFix", "invoke"));
            }
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/javascript/inspections/JSConsecutiveCommasInArrayLiteralInspection$InsertUndefinedFix", "invoke"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/lang/javascript/inspections/JSConsecutiveCommasInArrayLiteralInspection$InsertUndefinedFix", "invoke"));
            }
            ASTNode undefined = JSChangeUtil.createExpressionFromText(project, "undefined");
            startElement.getParent().addAfter(undefined.getPsi(), startElement);
        }

        @NotNull
        public String getText() {
            String string = JSBundle.message((String)"js.consecutive.commas.in.array.literal.inspection.insert.undefined", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSConsecutiveCommasInArrayLiteralInspection$InsertUndefinedFix", "getText"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSConsecutiveCommasInArrayLiteralInspection$InsertUndefinedFix", "getFamilyName"));
            }
            return string;
        }
    }
}

