/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JSComparisonWithNaNInspection
extends JSInspection {
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.comparison.with.nan.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSComparisonWithNaNInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSBinaryExpression(JSBinaryExpression node) {
                JSExpression exprComparedToNaN;
                IElementType sign = node.getOperationSign();
                if ((sign == JSTokenTypes.EQEQEQ || sign == JSTokenTypes.EQEQ || sign == JSTokenTypes.NEQEQ || sign == JSTokenTypes.NE) && (exprComparedToNaN = JSComparisonWithNaNInspection.findExpressionComparedToNaN(node)) != null) {
                    boolean addNot = sign == JSTokenTypes.NE || sign == JSTokenTypes.NEQEQ;
                    holder.registerProblem((PsiElement)node, JSBundle.message((String)(addNot ? "js.comparison.with.nan.inspection.problem2" : "js.comparison.with.nan.inspection.problem"), (Object[])new Object[0]), new LocalQuickFix[]{new JSReplaceWithIsNaNCallQuickFix(addNot)});
                }
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSComparisonWithNaNInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    private static JSExpression findExpressionComparedToNaN(JSBinaryExpression node) {
        JSExpression lOperand = node.getLOperand();
        JSExpression rOperand = node.getROperand();
        JSExpression exprComparedToNaN = null;
        if (lOperand instanceof JSReferenceExpression && "NaN".equals(lOperand.getText())) {
            exprComparedToNaN = rOperand;
        } else if (rOperand instanceof JSReferenceExpression && "NaN".equals(rOperand.getText())) {
            exprComparedToNaN = lOperand;
        }
        return exprComparedToNaN;
    }

    static class JSReplaceWithIsNaNCallQuickFix
    implements LocalQuickFix {
        private final boolean myAddNot;

        public JSReplaceWithIsNaNCallQuickFix(boolean addNot) {
            this.myAddNot = addNot;
        }

        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"js.comparison.with.nan.inspection.quickfix", (Object[])new Object[]{this.myAddNot ? "!" : ""});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSComparisonWithNaNInspection$JSReplaceWithIsNaNCallQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/JSComparisonWithNaNInspection$JSReplaceWithIsNaNCallQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/inspections/JSComparisonWithNaNInspection$JSReplaceWithIsNaNCallQuickFix", "applyFix"));
            }
            JSBinaryExpression node = (JSBinaryExpression)descriptor.getPsiElement();
            JSExpression expression = JSComparisonWithNaNInspection.findExpressionComparedToNaN(node);
            PsiFile file = node.getContainingFile();
            if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
                return;
            }
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            if (document != null) {
                document.replaceString(node.getTextRange().getStartOffset(), node.getTextRange().getEndOffset(), (CharSequence)((this.myAddNot ? "!" : "") + "isNaN(" + expression.getText() + ")"));
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            }
        }
    }
}

