/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.UnfairLocalInspectionTool;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAccessibilityCheckInspection
extends JSInspection
implements UnfairLocalInspectionTool {
    public static final String SHORT_NAME = JSAccessibilityCheckInspection.calcShortNameFromClass(JSAccessibilityCheckInspection.class);

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.accessibility.check.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSAccessibilityCheckInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSAccessibilityCheckInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor();
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSAccessibilityCheckInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    public static class SetJSDocElementVisibilityFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private final JSAttributeList.AccessType myNewVisibility;

        public SetJSDocElementVisibilityFix(@NotNull PsiElement element, JSAttributeList.AccessType newVisibility) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/JSAccessibilityCheckInspection$SetJSDocElementVisibilityFix", "<init>"));
            }
            super(element);
            this.myNewVisibility = newVisibility;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            JSDocTag[] tags;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/JSAccessibilityCheckInspection$SetJSDocElementVisibilityFix", "invoke"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/inspections/JSAccessibilityCheckInspection$SetJSDocElementVisibilityFix", "invoke"));
            }
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/javascript/inspections/JSAccessibilityCheckInspection$SetJSDocElementVisibilityFix", "invoke"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/lang/javascript/inspections/JSAccessibilityCheckInspection$SetJSDocElementVisibilityFix", "invoke"));
            }
            if (!FileModificationService.getInstance().preparePsiElementForWrite(startElement)) {
                return;
            }
            PsiComment comment = JSDocumentationUtils.findDocComment(startElement);
            if (!(comment instanceof JSDocComment)) {
                return;
            }
            for (JSDocTag tag : tags = ((JSDocComment)comment).getTags()) {
                String tagName = tag.getName();
                if (!"private".equals(tagName) && !"protected".equals(tagName) && !"public".equals(tagName)) continue;
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(comment.getContainingFile());
                if (document != null) {
                    String visibilityTag = JSVisibilityUtil.getJSDocVisibilityKeyword(this.myNewVisibility);
                    if (visibilityTag != null) {
                        document.replaceString(tag.getTextRange().getStartOffset(), tag.getTextRange().getEndOffset(), (CharSequence)("@" + visibilityTag));
                    } else {
                        document.deleteString(tag.getTextRange().getStartOffset(), tag.getTextRange().getEndOffset());
                    }
                    PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                }
                return;
            }
        }

        @NotNull
        public String getText() {
            PsiElement element = this.getStartElement();
            String name = element instanceof JSNamedElement ? ((JSNamedElement)element).getName() : "element";
            String visibility = JSVisibilityUtil.getJSDocVisibilityKeyword(this.myNewVisibility);
            if (visibility == null) {
                visibility = "default";
            }
            String string = JSBundle.message((String)"javascript.fix.set.element.visibility", (Object[])new Object[]{name, visibility});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSAccessibilityCheckInspection$SetJSDocElementVisibilityFix", "getText"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSAccessibilityCheckInspection$SetJSDocElementVisibilityFix", "getFamilyName"));
            }
            return string;
        }
    }
}

