/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigService;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.JSUnusedLocalSymbolsInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.resolve.JSNamedElementKind;
import com.intellij.lang.typescript.imports.ES6UnusedImportsHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;

public class ES6UnusedImportsInspection
extends JSInspection {
    public static final String SHORT_NAME = ES6UnusedImportsInspection.calcShortNameFromClass(ES6UnusedImportsInspection.class);

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.unused.es6.import.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6UnusedImportsInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitES6ImportDeclaration(ES6ImportDeclaration importDeclaration) {
                ES6UnusedImportsHelper.UnusedInfo info;
                if (importDeclaration.getLanguage() == JavaScriptSupportLoader.FLOW_JS) {
                    PsiFile file = importDeclaration.getContainingFile();
                    FlowJSConfigService service = FlowJSConfigService.getService(file.getProject());
                    FlowJSSettings settings = FlowJSSettingsManager.getInstance(file.getProject()).getFlowSettings();
                    if (service != null && settings.getFlowResolveEnable() && !service.getConfigOfFile(file.getVirtualFile()).isEmpty()) {
                        return;
                    }
                }
                if ((info = ES6UnusedImportsHelper.getInfo(importDeclaration)).isAllUnused()) {
                    LocalQuickFixAndIntentionActionOnPsiElement fix = JSFixFactory.getInstance().removeASTNodeFix("javascript.unused.import.remove", importDeclaration.getNode());
                    holder.registerProblem((PsiElement)importDeclaration, JSUnusedLocalSymbolsInspection.unusedMessage(JSNamedElementKind.ES6_IMPORT), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{fix});
                } else {
                    for (ES6ImportedBinding binding : info.getUnusedBindings()) {
                        holder.registerProblem((PsiElement)binding, JSUnusedLocalSymbolsInspection.unusedMessage(JSNamedElementKind.ES6_BINDING), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[0]);
                    }
                    for (ES6ImportSpecifier specifier : info.getUnusedSpecifiers()) {
                        holder.registerProblem((PsiReference)specifier, JSUnusedLocalSymbolsInspection.unusedMessage(JSNamedElementKind.ES6_SPECIFIER), ProblemHighlightType.LIKE_UNUSED_SYMBOL);
                    }
                }
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6UnusedImportsInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }
}

