/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.JsonFileType;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.inspections.ES6ConvertRequireIntoImportQuickFix;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ConvertRequireIntoImportInspection
extends JSInspection
implements ES6CoolRefactoring {
    public static final String ES6_CONVERT_REQUIRE_INTO_IMPORT = "ES6ConvertRequireIntoImport";
    public boolean myScopeOption;

    @Override
    @NotNull
    public String getShortName() {
        if (ES6_CONVERT_REQUIRE_INTO_IMPORT == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportInspection", "getShortName"));
        }
        return ES6_CONVERT_REQUIRE_INTO_IMPORT;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSCallExpression(JSCallExpression call) {
                boolean isBatch;
                if (!ES6CoolRefactoring.isEs6Compatible((PsiElement)call)) {
                    return;
                }
                if (!call.isRequireCall()) {
                    return;
                }
                JSExpression[] arguments = call.getArguments();
                boolean bl = isBatch = !holder.isOnTheFly();
                if (arguments.length == 1 && arguments[0] instanceof JSLiteralExpression && ((JSLiteralExpression)arguments[0]).isQuotedLiteral()) {
                    if (!ES6ConvertRequireIntoImportInspection.checkArgument(StringUtil.unquoteString((String)arguments[0].getText())) || isBatch && !ES6ConvertRequireIntoImportInspection.this.myScopeOption && !ES6ConvertRequireIntoImportInspection.checkScope(call)) {
                        return;
                    }
                    holder.registerProblem((PsiElement)call, JSBundle.message((String)"js.convert.require.into.es6.import.inspection.text", (Object[])new Object[0]), new LocalQuickFix[]{new ES6ConvertRequireIntoImportQuickFix(call)});
                }
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    private static boolean checkArgument(@NotNull String requireArgument) {
        if (requireArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requireArgument", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportInspection", "checkArgument"));
        }
        String extension = FileUtilRt.getExtension((String)ES6ConvertRequireIntoImportInspection.cutRelativePathStartAndForwardSlash(requireArgument));
        if (extension.isEmpty() || "node".equals(extension)) {
            return true;
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension(extension);
        return fileType instanceof LanguageFileType && ((LanguageFileType)fileType).getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE) || JsonFileType.INSTANCE.equals(fileType);
    }

    @NotNull
    public static String cutRelativePathStartAndForwardSlash(@NotNull String argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportInspection", "cutRelativePathStartAndForwardSlash"));
        }
        String[] parts = argument.replace('\\', '/').split("/");
        StringBuilder sb = new StringBuilder();
        boolean started = false;
        for (String part : parts) {
            if (!(".".equals(part) || "..".equals(part) || part.isEmpty())) {
                if (!started) {
                    started = true;
                }
            } else if (!started) continue;
            if (sb.length() > 0) {
                sb.append("/");
            }
            sb.append(part);
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportInspection", "cutRelativePathStartAndForwardSlash"));
        }
        return string;
    }

    private static boolean checkScope(@NotNull JSCallExpression call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportInspection", "checkScope"));
        }
        JSSourceElement immediateSourceElement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)call, JSSourceElement.class);
        if (immediateSourceElement == null) {
            return false;
        }
        if (immediateSourceElement.getParent() instanceof PsiFile && call.getContainingFile().equals(immediateSourceElement.getParent())) {
            return true;
        }
        return immediateSourceElement.getParent() instanceof JSEmbeddedContent;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return this.createSingleCheckboxOptionsPanelWithHint(JSBundle.message((String)"js.convert.require.into.es6.import.inspection.withConditional.option", (Object[])new Object[0]), JSBundle.message((String)"js.convert.require.into.es6.import.inspection.withConditional.option.description", (Object[])new Object[0]), "myScopeOption");
    }
}

