/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inject;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import org.intellij.lang.regexp.DefaultRegExpPropertiesProvider;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRegexpHost
implements RegExpLanguageHost {
    private final DefaultRegExpPropertiesProvider myPropertiesProvider = DefaultRegExpPropertiesProvider.getInstance();

    public boolean characterNeedsEscaping(char c) {
        return c == '/';
    }

    public boolean supportsPerl5EmbeddedComments() {
        return false;
    }

    public boolean supportsPossessiveQuantifiers() {
        return false;
    }

    public boolean supportsPythonConditionalRefs() {
        return false;
    }

    public boolean supportsNamedGroupSyntax(RegExpGroup group) {
        if (!group.isPythonNamedGroup()) {
            return false;
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)group.getProject()).getInjectionHost((PsiElement)group);
        return host != null && DialectDetector.isActionScript((PsiElement)host);
    }

    public boolean supportsNamedGroupRefSyntax(RegExpNamedGroupRef ref) {
        if (!ref.isPythonNamedGroupRef()) {
            return false;
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)ref.getProject()).getInjectionHost((PsiElement)ref);
        return host != null && DialectDetector.isActionScript((PsiElement)host);
    }

    public boolean supportsExtendedHexCharacter(RegExpChar regExpChar) {
        return false;
    }

    public boolean isValidCategory(@NotNull String category) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/lang/javascript/inject/JSRegexpHost", "isValidCategory"));
        }
        return this.myPropertiesProvider.isValidCategory(category);
    }

    @NotNull
    public String[][] getAllKnownProperties() {
        String[][] stringArray = this.myPropertiesProvider.getAllKnownProperties();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inject/JSRegexpHost", "getAllKnownProperties"));
        }
        return stringArray;
    }

    @Nullable
    public String getPropertyDescription(@Nullable String name) {
        return this.myPropertiesProvider.getPropertyDescription(name);
    }

    @NotNull
    public String[][] getKnownCharacterClasses() {
        String[][] stringArray = this.myPropertiesProvider.getKnownCharacterClasses();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inject/JSRegexpHost", "getKnownCharacterClasses"));
        }
        return stringArray;
    }
}

