/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.index.predefined.Marker;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.descriptor.BrowserVersion;
import com.intellij.psi.css.impl.util.scheme.CssElementDescriptorFactory2;
import com.intellij.util.JdomKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PredefinedJSFilesGenerator {
    private static final String[] IDL_PATHS;
    private final StringBuilder builder;
    private boolean libraryMethodParamMandatoryByDefault;
    private boolean methodParamMandatoryByDefault;
    private final Condition<String> sinceCondition;
    private final boolean appendOnlyMembers;
    @NonNls
    public static final String GLOBAL = "global";
    @NonNls
    private static final String NAME_ATTR_NAME = "name";
    @NonNls
    private static final String METHOD_TAG_NAME = "method";
    @NonNls
    private static final String PARAM_TAG_NAME = "param";
    @NonNls
    private static final String PROPERTY_TAG_NAME = "property";
    @NonNls
    private static final String BROWSER_ATTR_NAME = "browser";
    @NonNls
    private static final String DEPRECATED_ATTR_NAME = "deprecated";
    @NonNls
    private static final String IMPLEMENTS_ATTR_NAME = "implements";
    @NonNls
    private static final String TEMPLATE_PARAMETER_ATTR_NAME = "template";
    @NonNls
    private static final String GLOBAL_CLASS_NAME = "Global";
    @NonNls
    private static final String OBJECT_CLASS_NAME = "Object";

    public PredefinedJSFilesGenerator(StringBuilder builder, boolean appendOnlyMembers, Condition<String> sinceCondition) {
        this.builder = builder;
        this.sinceCondition = sinceCondition;
        this.appendOnlyMembers = appendOnlyMembers;
    }

    public static void main(String[] args) {
        if (args.length == 1 && args[0].equals("all")) {
            for (String idlPath : IDL_PATHS) {
                String libPath = PathManager.getHomePath() + "/" + idlPath + "/";
                File path = new File(libPath);
                String outputPath = path.getPath() + '/';
                for (File file : path.listFiles()) {
                    if (!file.getName().endsWith(".xml")) continue;
                    PredefinedJSFilesGenerator.generateFile(file, outputPath);
                }
            }
        } else {
            String libPath = PathManager.getHomePath() + "/" + IDL_PATHS[0] + "/";
            PredefinedJSFilesGenerator.generateFile(new File(libPath + "ECMAScript7.xml"), libPath);
        }
    }

    public static void generateFile(File myFile, String outputPath) {
        try {
            String originalFileName = myFile.getName();
            String myFileName = StringUtil.replace((String)originalFileName, (String)".xml", (String)".js");
            String s = PredefinedJSFilesGenerator.translateFile(new FileInputStream(myFile), originalFileName);
            FileUtil.writeToFile((File)new File(outputPath + myFileName), (byte[])s.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String translateFile(InputStream inputStream, String fileName) {
        try {
            StringBuilder builder = new StringBuilder(8192);
            Condition sinceCondition = fileName.equals("EcmaScript.xml") || fileName.equals("AJAX.xml") || fileName.equals("DHTML.xml") ? since -> StringUtil.compareVersionNumbers((String)since, (String)"3") <= 0 : Conditions.alwaysTrue();
            new PredefinedJSFilesGenerator(builder, false, (Condition<String>)sinceCondition).processLibrary(JdomKt.loadElement((InputStream)inputStream));
            if (fileName.equals("EcmaScript5.xml") || fileName.equals("HTML5.xml")) {
                Condition condition = since -> "5".equals(since);
                String[] additionalDocuments = fileName.equals("HTML5.xml") ? new String[]{"AJAX.xml", "DHTML.xml"} : new String[]{"EcmaScript.xml"};
                for (String additionalDocument : additionalDocuments) {
                    new PredefinedJSFilesGenerator(builder, true, (Condition<String>)condition).processLibrary(JDOMUtil.loadDocument((InputStream)Marker.class.getResourceAsStream(additionalDocument)).getRootElement());
                }
            }
            if (fileName.equals("DHTML.xml")) {
                try {
                    MultiMap properties = new CssElementDescriptorFactory2(null).getProperties();
                    ArrayList propertyNames = ContainerUtil.newArrayList((Iterable)properties.keySet());
                    Collections.sort(propertyNames);
                    StringBuilder result = new StringBuilder();
                    for (String propertyName : propertyNames) {
                        result.setLength(0);
                        result.ensureCapacity(propertyName.length());
                        StringTokenizer tokenizer = new StringTokenizer(propertyName, "-");
                        while (tokenizer.hasMoreTokens()) {
                            String token = tokenizer.nextToken();
                            if (result.length() != 0) {
                                token = StringUtil.capitalize((String)token);
                            }
                            result.append(token);
                        }
                        HashSet<String> browsers = new HashSet<String>();
                        for (CssPropertyDescriptor descriptor : properties.get((Object)propertyName)) {
                            for (BrowserVersion version : descriptor.getBrowsers()) {
                                browsers.add(version.getBrowser().getPresentableName());
                            }
                        }
                        String browser = null;
                        if (browsers.size() == 1) {
                            String name = (String)browsers.iterator().next();
                            browser = "Firefox".equals(name) ? "Gecko" : name;
                        } else if (propertyName.startsWith("-ms-") || propertyName.startsWith("mso-")) {
                            browser = "IE";
                        } else if (propertyName.startsWith("-moz-")) {
                            browser = "Gecko";
                        } else if (propertyName.startsWith("-o-")) {
                            browser = "Opera";
                        }
                        if (browser != null) {
                            builder.append("/**\n@browser ").append(browser).append("\n*/\n");
                        }
                        builder.append("CSSStyleDeclaration.prototype.").append(result.toString()).append(" = 0 || '';\n");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return builder.toString();
        }
        catch (Exception e) {
            JavaScriptIndex.LOG.error((Throwable)e);
            return null;
        }
    }

    private void processLibrary(Element element) {
        this.libraryMethodParamMandatoryByDefault = "true".equals(element.getAttributeValue("paramPolicyMandatory"));
        this.processClasses(element.getContent());
    }

    private void processClasses(List elements) {
        for (Object e : elements) {
            if (!(e instanceof Element)) continue;
            Element element = (Element)e;
            Type type = Type.ofTag(element.getName());
            if (type == Type.TYPEDEF) {
                this.builder.append("\n/**\n * @typedef {").append(element.getAttributeValue("type")).append("} ").append(element.getAttributeValue(NAME_ATTR_NAME)).append("\n*/\n");
                continue;
            }
            if (type == null) continue;
            if (this.builder.length() > 0 && !this.appendOnlyMembers) {
                this.builder.append('\n');
            }
            String className = element.getAttributeValue(NAME_ATTR_NAME);
            String extendsFromName = element.getAttributeValue("extends");
            if (extendsFromName == null && !GLOBAL_CLASS_NAME.equals(className) && !OBJECT_CLASS_NAME.equals(className)) {
                extendsFromName = null;
            }
            this.translateOneClass(element, className, extendsFromName, type);
        }
    }

    private void translateOneClass(Element element, String className, String extendsClassName, @NotNull Type type) {
        boolean addJSDoc;
        boolean addExtendsFromJSDoc;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/index/PredefinedJSFilesGenerator", "translateOneClass"));
        }
        String targetBrowser = element.getAttributeValue(BROWSER_ATTR_NAME);
        String selectionExpr = !className.equals(GLOBAL_CLASS_NAME) ? className + '.' : "";
        String implementsName = element.getAttributeValue(IMPLEMENTS_ATTR_NAME);
        String classTemplate = element.getAttributeValue(TEMPLATE_PARAMETER_ATTR_NAME);
        Element staticMembers = element.getChild("static");
        boolean seenConstructor = false;
        boolean isTrait = type == Type.TRAIT;
        boolean bl = this.methodParamMandatoryByDefault = isTrait || this.libraryMethodParamMandatoryByDefault || "true".equals(element.getAttributeValue("paramPolicyMandatory"));
        if (staticMembers != null) {
            seenConstructor = this.processMembers(true, staticMembers, targetBrowser, selectionExpr, classTemplate);
        }
        seenConstructor |= this.processMembers(type == Type.NAMESPACE, element, targetBrowser, selectionExpr, classTemplate);
        if (this.appendOnlyMembers) {
            return;
        }
        boolean bl2 = addExtendsFromJSDoc = extendsClassName != null && StringUtil.containsAnyChar((String)extendsClassName, (String)"< ");
        if (extendsClassName != null && !addExtendsFromJSDoc) {
            this.builder.append(className).append(".prototype = new ").append(extendsClassName).append("();\n");
        }
        boolean createInitializer = !isTrait && !seenConstructor && selectionExpr.length() > 0 && !"false".equals(element.getAttributeValue("createStaticVar"));
        boolean addGlobal = type == Type.NAMESPACE;
        boolean bl3 = addJSDoc = implementsName != null || classTemplate != null && !seenConstructor || isTrait || addExtendsFromJSDoc || addGlobal;
        if (addJSDoc) {
            this.builder.append("/**\n");
            if (isTrait) {
                this.builder.append("@interface\n");
            }
            if (!createInitializer && !isTrait) {
                this.builder.append("@class ").append(className).append("\n");
            }
            if (classTemplate != null) {
                this.builder.append("@template ").append(classTemplate).append("\n");
            }
            if (addExtendsFromJSDoc) {
                this.builder.append("@extends {").append(extendsClassName).append("}\n");
            }
            if (implementsName != null) {
                this.builder.append("@implements {").append(implementsName).append("}\n");
            }
            if (addGlobal) {
                this.builder.append("@global\n");
            }
            this.builder.append("*/\n");
        }
        if (isTrait) {
            this.builder.append("function ").append(className).append("() {}\n");
        } else if (createInitializer) {
            if (type == Type.NAMESPACE) {
                this.builder.append("var ");
            }
            this.builder.append(selectionExpr.substring(0, selectionExpr.length() - 1)).append(" = {};\n");
        } else if (addJSDoc) {
            this.builder.append(className).append("();\n");
        }
        if ("true".equals(element.getAttributeValue("exposeAsProperty")) && !className.equals("Window")) {
            this.builder.append("/**\n * @type ").append(className).append("\n */\n").append(Character.toLowerCase(className.charAt(0))).append(className, 1, className.length()).append(" = {};\n");
        }
    }

    private boolean processMembers(boolean isStatic, Element element, String targetBrowser, String selectionExpr, String classTemplate) {
        boolean seenConstructor = this.processNodes(isStatic, element.getChildren(PROPERTY_TAG_NAME), selectionExpr, targetBrowser, classTemplate);
        return seenConstructor |= this.processNodes(isStatic, element.getChildren(METHOD_TAG_NAME), selectionExpr, targetBrowser, classTemplate);
    }

    private boolean processNodes(boolean isStatic, List children, String selectionExpr, String browserSpecific, String classTemplate) {
        boolean headerStarted = false;
        boolean seenConstructor = false;
        String className = selectionExpr.length() == 0 ? GLOBAL : selectionExpr.substring(0, selectionExpr.length() - 1);
        boolean global = GLOBAL.equals(className);
        for (Object node : children) {
            String type;
            String typeValue;
            if (!(node instanceof Element)) continue;
            Element subElement = (Element)node;
            String name = subElement.getAttributeValue(NAME_ATTR_NAME);
            boolean method = METHOD_TAG_NAME.equals(subElement.getName());
            boolean property = PROPERTY_TAG_NAME.equals(subElement.getName());
            if (!method && !property || !this.sinceCondition.value((Object)subElement.getAttributeValue("since"))) continue;
            boolean deprecated = "true".equals(subElement.getAttributeValue(DEPRECATED_ATTR_NAME));
            String methodTemplate = subElement.getAttributeValue(TEMPLATE_PARAMETER_ATTR_NAME);
            String elementBrowserSpecific = subElement.getAttributeValue(BROWSER_ATTR_NAME);
            if (elementBrowserSpecific == null) {
                elementBrowserSpecific = browserSpecific;
            }
            String paramsDocs = null;
            boolean constant = false;
            boolean writeOnly = false;
            if (method) {
                boolean constructor = "__constructor__".equals(name);
                List grandchildren = subElement.getChildren(PARAM_TAG_NAME);
                String paramString = "";
                boolean hasSomeInfo = false;
                for (Object p : grandchildren) {
                    boolean rest;
                    Element param = (Element)p;
                    String paramName = param.getAttributeValue(NAME_ATTR_NAME);
                    String paramType = PredefinedJSFilesGenerator.transformTypeRef(className, PredefinedJSFilesGenerator.getType(param));
                    boolean optional = this.methodParamMandatoryByDefault ? "true".equals(param.getAttributeValue("optional")) : !"false".equals(param.getAttributeValue("optional"));
                    String defaultValue = param.getAttributeValue("default");
                    if (!optional && defaultValue != null) {
                        optional = true;
                    }
                    boolean bl = rest = param.getAttributeValue("rest") != null;
                    if (paramsDocs == null) {
                        paramsDocs = "";
                    }
                    paramsDocs = paramsDocs + "@param ";
                    if (rest) {
                        paramType = "..." + paramType;
                    }
                    if (paramType != null) {
                        paramsDocs = paramsDocs + "{" + paramType + "} ";
                    }
                    paramsDocs = paramsDocs + (optional ? "[" : "") + paramName;
                    if (defaultValue != null) {
                        paramsDocs = paramsDocs + " = " + defaultValue;
                    }
                    paramsDocs = paramsDocs + (optional ? "]" : "") + "\n";
                    if (paramName.indexOf(46) == -1) {
                        if (paramString.length() > 0) {
                            paramString = paramString + ",";
                        }
                        paramString = paramString + paramName;
                    }
                    hasSomeInfo |= paramType != null || optional;
                }
                if (!hasSomeInfo) {
                    paramsDocs = null;
                }
                typeValue = PredefinedJSFilesGenerator.getType(subElement, "returnType");
                if (constructor) {
                    seenConstructor = true;
                    if (paramsDocs == null) {
                        paramsDocs = "";
                    }
                    paramsDocs = paramsDocs + "@constructor\n";
                    PredefinedJSFilesGenerator.appendDoc(this.builder, method, typeValue, deprecated, elementBrowserSpecific, paramsDocs, constant, classTemplate);
                    this.builder.append("function ").append(className).append("(").append(paramString).append(") {}\n");
                    continue;
                }
                type = "function(" + paramString + ") {}";
            } else {
                if (!property) continue;
                if ("constructor".equals(name) && !OBJECT_CLASS_NAME.equals(className)) {
                    seenConstructor = true;
                    this.builder.append(className).append(" = ").append("function() {};\n");
                }
                typeValue = PredefinedJSFilesGenerator.getType(subElement);
                String s = subElement.getAttributeValue("value");
                type = s != null ? s : this.defaultForType(typeValue);
                s = subElement.getAttributeValue("attribute");
                boolean bl = constant = s != null && "readonly".equalsIgnoreCase(s);
                if (s == null) {
                    s = subElement.getAttributeValue("readOnly");
                    boolean bl2 = constant = s != null && "true".equalsIgnoreCase(s);
                }
                if (!constant) {
                    s = subElement.getAttributeValue("writeOnly");
                    boolean bl3 = writeOnly = s != null && "true".equalsIgnoreCase(s);
                }
            }
            if (isStatic) {
                if (paramsDocs == null) {
                    paramsDocs = "";
                }
                paramsDocs = paramsDocs + "@static\n";
            }
            typeValue = PredefinedJSFilesGenerator.transformTypeRef(className, typeValue);
            PredefinedJSFilesGenerator.appendDoc(this.builder, method, typeValue, deprecated, elementBrowserSpecific, paramsDocs, constant, methodTemplate);
            if (writeOnly) {
                this.builder.append("Object.defineProperty(").append(className).append(", \"").append(name).append("\", { set: function(value) {} });");
            } else {
                this.builder.append(selectionExpr);
                if (!isStatic && !global) {
                    this.builder.append("prototype.");
                }
                this.builder.append(name).append(" = ").append(type).append(";");
            }
            this.builder.append('\n');
        }
        if (headerStarted) {
            this.builder.append("\n};\n");
        }
        return seenConstructor;
    }

    private String defaultForType(String value) {
        if ("string".equals(value)) {
            return null;
        }
        return "0";
    }

    private static String getType(Element tag) {
        return PredefinedJSFilesGenerator.getType(tag, "type");
    }

    private static String getType(Element tag, String attributeName) {
        String type = tag.getAttributeValue(attributeName);
        if (type != null) {
            if ((type = StringUtil.trimEnd((String)type, (String)"?")).equalsIgnoreCase("long") || type.equalsIgnoreCase("float") || type.equalsIgnoreCase("int") || type.equalsIgnoreCase("byte") || type.equalsIgnoreCase("short") || type.equalsIgnoreCase("double")) {
                return "number";
            }
            if (type.equals("String")) {
                type = "string";
            } else if (type.equals("Boolean")) {
                type = "boolean";
            } else if (type.startsWith("function(") || type.charAt(0) == '{') {
                type = type.replaceAll("([\\W]+)Long|Int|Short|Byte|Float|Double", "$1Number");
            }
        }
        return type;
    }

    private static void appendDoc(StringBuilder builder, boolean method, String typeValue, boolean deprecated, String elementBrowserSpecific, String paramsDocs, boolean constant, String template) {
        boolean haveType;
        boolean bl = haveType = !StringUtil.isEmpty((String)typeValue);
        if (haveType || elementBrowserSpecific != null || deprecated || paramsDocs != null) {
            builder.append("/**\n");
            if (elementBrowserSpecific != null) {
                builder.append("@browser ").append(elementBrowserSpecific).append("\n");
            }
            if (paramsDocs != null) {
                builder.append(paramsDocs);
            }
            if (haveType) {
                builder.append(method ? "@return" : "@type").append(" {").append(typeValue).append("}\n");
            }
            if (constant) {
                builder.append("@const\n");
            }
            if (deprecated) {
                builder.append("@deprecated\n");
            }
            if (template != null) {
                builder.append("@template ").append(template).append("\n");
            }
            builder.append("*/\n");
        }
    }

    private static String transformTypeRef(String className, String typeValue) {
        if ("$__Type__$".equals(typeValue)) {
            typeValue = className;
        }
        return typeValue;
    }

    static {
        System.setProperty("apple.awt.UIElement", "true");
        IDL_PATHS = new String[]{"plugins/JavaScriptLanguage/javascript-psi-impl/src/com/intellij/lang/javascript/index/predefined", "plugins/JavaScriptLanguage/js-nashorn/src/com/intellij/lang/javascript/nashorn/library"};
    }

    static enum Type {
        CLASS("class"),
        TRAIT("trait"),
        NAMESPACE("namespace"),
        TYPEDEF("typedef");

        String myTag;

        private Type(String tag) {
            this.myTag = tag;
        }

        @Nullable
        static Type ofTag(String tag) {
            for (Type type : Type.values()) {
                if (!type.myTag.equals(tag)) continue;
                return type;
            }
            return null;
        }
    }
}

