/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.index.JSIndexPatternBuilder;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.util.JSDirectiveCommentLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.cache.impl.BaseFilterLexer;
import com.intellij.psi.impl.cache.impl.OccurrenceConsumer;
import com.intellij.psi.impl.cache.impl.todo.LexerBasedTodoIndexer;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.indexing.FileContent;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JSTodoIndexer
extends LexerBasedTodoIndexer {
    @NotNull
    public Map<TodoIndexEntry, Integer> map(@NotNull FileContent inputData) {
        if (inputData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/lang/javascript/index/JSTodoIndexer", "map"));
        }
        VirtualFile file = inputData.getFile();
        if (JSLibraryUtil.isProbableLibraryFile(file)) {
            Map<TodoIndexEntry, Integer> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSTodoIndexer", "map"));
            }
            return map;
        }
        Project project = inputData.getProject();
        if (project != null && JSLibraryManager.getInstance(project).isPredefinedLibraryFile(file)) {
            Map<TodoIndexEntry, Integer> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSTodoIndexer", "map"));
            }
            return map;
        }
        Map map = super.map(inputData);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSTodoIndexer", "map"));
        }
        return map;
    }

    public Lexer createLexer(OccurrenceConsumer consumer) {
        JSFlexAdapter delegate = new JSFlexAdapter(this.getOptionHolder());
        return new BaseFilterLexer((Lexer)new JSDirectiveCommentLexer((Lexer)delegate), consumer){

            public void advance() {
                IElementType tokenType = this.myDelegate.getTokenType();
                if (JSIndexPatternBuilder.Holder.COMMENTS_FOR_INDEXING.contains(tokenType)) {
                    this.scanWordsInToken(2, false, false);
                    this.advanceTodoItemCountsInToken();
                }
                this.myDelegate.advance();
            }
        };
    }

    protected DialectOptionHolder getOptionHolder() {
        return JavascriptLanguage.DIALECT_OPTION_HOLDER;
    }
}

