/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import org.jetbrains.annotations.NotNull;

public class JSPackageIndexInfo {
    public final String name;
    public final Kind kind;
    public final boolean isPublic;

    public JSPackageIndexInfo(@NotNull String name, @NotNull Kind kind, boolean isPublic) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/index/JSPackageIndexInfo", "<init>"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/lang/javascript/index/JSPackageIndexInfo", "<init>"));
        }
        this.kind = kind;
        this.name = name;
        this.isPublic = isPublic;
    }

    public boolean isEquivalentTo(@NotNull String el, @NotNull Kind currentKind, boolean currentPublic) {
        if (el == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "el", "com/intellij/lang/javascript/index/JSPackageIndexInfo", "isEquivalentTo"));
        }
        if (currentKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentKind", "com/intellij/lang/javascript/index/JSPackageIndexInfo", "isEquivalentTo"));
        }
        return this.kind == currentKind && this.isPublic == currentPublic && this.name.equals(el);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSPackageIndexInfo that = (JSPackageIndexInfo)o;
        if (this.isPublic != that.isPublic) {
            return false;
        }
        if (this.kind != that.kind) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.kind.hashCode();
        result = 31 * result + (this.isPublic ? 1 : 0);
        return result;
    }

    public static enum Kind {
        PACKAGE,
        CLASS,
        INTERFACE,
        VARIABLE,
        FUNCTION;

    }
}

